/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.components;

import java.util.Iterator;
import org.apache.tapestry.AbstractComponent;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.Tapestry;

public abstract class Foreach
extends AbstractComponent {
    private Object _value;
    private int _index;
    private boolean _rendering;

    public abstract IBinding getIndexBinding();

    protected Iterator getSourceData() {
        Object source = this.getSource();
        if (source == null) {
            return null;
        }
        return Tapestry.coerceToIterator(source);
    }

    public abstract IBinding getValueBinding();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        Iterator dataSource = this.getSourceData();
        if (dataSource == null) {
            return;
        }
        try {
            this._rendering = true;
            this._value = null;
            this._index = 0;
            IBinding indexBinding = this.getIndexBinding();
            IBinding valueBinding = this.getValueBinding();
            String element = this.getElement();
            boolean hasNext = dataSource.hasNext();
            while (hasNext) {
                this._value = dataSource.next();
                hasNext = dataSource.hasNext();
                if (indexBinding != null) {
                    indexBinding.setInt(this._index);
                }
                if (valueBinding != null) {
                    valueBinding.setObject(this._value);
                }
                if (element != null) {
                    writer.begin(element);
                    this.renderInformalParameters(writer, cycle);
                }
                this.renderBody(writer, cycle);
                if (element != null) {
                    writer.end();
                }
                ++this._index;
            }
        }
        finally {
            this._value = null;
            this._rendering = false;
        }
    }

    public Object getValue() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "value");
        }
        return this._value;
    }

    public abstract String getElement();

    public abstract Object getSource();

    public int getIndex() {
        if (!this._rendering) {
            throw Tapestry.createRenderOnlyPropertyException(this, "index");
        }
        return this._index;
    }
}

