package org.seasar.framework.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;


public final class LikeUtil {

	private static Map patterns_ = Collections.synchronizedMap(new HashMap());

	private LikeUtil() {
	}

	public static final boolean match(String patternStr, String value) {
		if (StringUtil.isEmpty(patternStr)) {
			return false;
		}
		Pattern pattern = (Pattern) patterns_.get(patternStr);
		if (pattern == null) {
			String regexp = StringUtil.replace(patternStr, "_", ".");
			regexp = StringUtil.replace(regexp, "%", ".*");
			pattern = Pattern.compile(regexp);
			patterns_.put(patternStr, pattern);
		}
		return pattern.matcher(value).matches();
	}
}