/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.remoting.axis.deployment;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.TypeMapping;
import org.apache.axis.Constants;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.apache.axis.deployment.wsdd.WSDDTypeMapping;
import org.apache.axis.description.JavaServiceDesc;
import org.apache.axis.encoding.TypeMappingDelegate;
import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.StringUtil;
import org.seasar.remoting.axis.ServiceDef;
import org.seasar.remoting.axis.TypeMappingDef;
import org.w3c.dom.Element;

public class WSDDS2Service
extends WSDDService {
    protected static final Map providerMapping = new HashMap();
    protected ComponentDef componentDef;

    public WSDDS2Service(ComponentDef componentDef) throws WSDDException {
        this(componentDef, new ServiceDef());
    }

    public WSDDS2Service(ComponentDef componentDef, ServiceDef serviceDef) throws WSDDException {
        this.componentDef = componentDef;
        String name = this.getName();
        this.setQName(new QName(name));
        JavaServiceDesc serviceDesc = (JavaServiceDesc)this.getServiceDesc();
        serviceDesc.setName(name);
        Class serviceType = this.getServiceClass(serviceDef);
        if (serviceType == null) {
            serviceType = componentDef.getComponentClass();
        }
        if (serviceType == null) {
            throw new WSDDException(MessageFormatter.getSimpleMessage((String)"EAXS0006", (Object[])new Object[]{name}));
        }
        this.setParameter("className", serviceType.getName());
        this.setProviderQName(new QName("http://xml.apache.org/axis/wsdd/providers/java", this.getS2Provider(serviceDef.getProvider())));
        String allowedMethods = serviceDef.getAllowedMethods();
        if (!StringUtil.isEmpty((String)allowedMethods)) {
            this.setParameter("allowedMethods", allowedMethods);
        }
        Iterator typeMappingDefs = serviceDef.getTypeMappings();
        while (typeMappingDefs.hasNext()) {
            TypeMappingDef typeMappingDef = (TypeMappingDef)typeMappingDefs.next();
            this.addTypeMapping(this.createWSDDTypeMapping(typeMappingDef));
        }
        this.initTMR();
        this.validateDescriptors();
        TypeMappingRegistry tmr = serviceDesc.getTypeMappingRegistry();
        TypeMapping tm = tmr.getTypeMapping(Use.DEFAULT.getEncoding());
        ((TypeMappingDelegate)tm).setDoAutoTypes(true);
    }

    public WSDDS2Service(ComponentDef componentDef, Element serviceElement) throws WSDDException {
        super(serviceElement);
        this.componentDef = componentDef;
        String provider = this.getProviderQName().getLocalPart();
        this.setProviderQName(new QName("http://xml.apache.org/axis/wsdd/providers/java", this.getS2Provider(provider)));
    }

    public ComponentDef getComponentDef() {
        return this.componentDef;
    }

    protected String getName() {
        String namespace = this.componentDef.getContainer().getNamespace();
        String componentName = this.componentDef.getComponentName();
        if (StringUtil.isEmpty((String)namespace)) {
            return componentName;
        }
        return namespace + "/" + componentName;
    }

    protected Class getServiceClass(ServiceDef serviceDef) {
        Class serviceType = null;
        serviceType = serviceDef.getServiceType();
        if (serviceType != null) {
            return serviceType;
        }
        serviceType = this.componentDef.getComponentClass();
        if (serviceType == null) {
            this.componentDef.getComponent().getClass();
        }
        if (!serviceType.isInterface()) {
            Class<?>[] interfaces = serviceType.getInterfaces();
            ArrayList interfaceList = new ArrayList();
            StringBuffer buf = new StringBuffer(200);
            for (int i = 0; i < interfaces.length; ++i) {
                Method[] methods = interfaces[i].getMethods();
                if (methods.length <= 0) continue;
                interfaceList.add(interfaces[i]);
                for (int j = 0; j < methods.length; ++j) {
                    buf.append(methods[j].getName()).append(" ");
                }
            }
            switch (interfaceList.size()) {
                case 0: {
                    break;
                }
                case 1: {
                    serviceType = (Class)interfaceList.get(0);
                    break;
                }
                default: {
                    if (serviceDef.getAllowedMethods() != null) break;
                    serviceDef.setAllowedMethods(new String(buf));
                }
            }
        }
        return serviceType;
    }

    protected String getS2Provider(String provider) throws WSDDException {
        String s2Provider = (String)providerMapping.get(provider);
        if (s2Provider == null) {
            throw new WSDDException(provider);
        }
        return s2Provider;
    }

    protected WSDDTypeMapping createWSDDTypeMapping(TypeMappingDef typeMappingDef) {
        WSDDTypeMapping wsddTypeMapping = new WSDDTypeMapping();
        Class type = typeMappingDef.getType();
        wsddTypeMapping.setLanguageSpecificType(typeMappingDef.getType());
        wsddTypeMapping.setQName(this.createQNameOfType(type, typeMappingDef.getNamespaceURI(), typeMappingDef.getLocalPart(), typeMappingDef.getNamespacePrefix()));
        if (typeMappingDef.getSerializer() != null) {
            wsddTypeMapping.setSerializer(typeMappingDef.getSerializer());
        }
        if (typeMappingDef.getDeserializer() != null) {
            wsddTypeMapping.setDeserializer(typeMappingDef.getDeserializer());
        }
        if (typeMappingDef.getEncodingStyle() == null) {
            wsddTypeMapping.setEncodingStyle(Constants.URI_DEFAULT_SOAP_ENC);
        } else {
            wsddTypeMapping.setEncodingStyle(typeMappingDef.getEncodingStyle());
        }
        return wsddTypeMapping;
    }

    protected QName createQNameOfType(Class type, String namespaceURI, String localPart, String namespacePrefix) {
        if (StringUtil.isEmpty((String)namespaceURI)) {
            namespaceURI = Namespaces.makeNamespace((String)type.getName());
        }
        if (StringUtil.isEmpty((String)localPart)) {
            localPart = Types.getLocalNameFromFullName((String)type.getName());
        }
        return new QName(namespaceURI, localPart, namespacePrefix);
    }

    static {
        providerMapping.put("RPC", "S2RPC");
        providerMapping.put("RPC", "S2RPC");
    }
}

