/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployment;

import java.io.Serializable;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.remoting.axis.ServiceDef;

/**
 * @author koichik
 */
public class WSDDS2ServiceTest extends S2TestCase {
    public WSDDS2ServiceTest(String name) {
        super(name);
    }

    public void setUp() {
        include("WSDDS2ServiceTest.dicon");
    }

    public void testGetServiceClass() throws Exception {
        ServiceDef sd = new ServiceDef();
        ComponentDef cd = getComponentDef("no");
        WSDDS2Service s2Service = new WSDDS2Service(cd, sd);
        assertEquals("1", NoInterface.class, s2Service.getServiceClass(sd));
        assertNull("2", sd.getAllowedMethods());

        cd = getComponentDef("one");
        s2Service = new WSDDS2Service(cd, sd);
        assertEquals("3", Runnable.class, s2Service.getServiceClass(sd));
        assertNull("4", sd.getAllowedMethods());

        cd = getComponentDef("two");
        s2Service = new WSDDS2Service(cd, sd);
        assertEquals("5", TwoInterface.class, s2Service.getServiceClass(sd));
        assertEquals("6", "run compareTo ", sd.getAllowedMethods());

        sd.setAllowedMethods("run");
        cd = getComponentDef("two");
        s2Service = new WSDDS2Service(cd, sd);
        assertEquals("7", TwoInterface.class, s2Service.getServiceClass(sd));
        assertEquals("8", "run", sd.getAllowedMethods());
    }

    public static class NoInterface implements Serializable {
    }

    public static class OneInterface implements Runnable, Serializable {
        public void run() {
        }
    }

    public static class TwoInterface implements Runnable, Comparable, Serializable {
        public void run() {
        }

        public int compareTo(Object o) {
            return 0;
        }
    }
}