/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployer;

import java.io.InputStream;

import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.utils.XMLUtils;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.remoting.axis.DeployFailedException;

/**
 * dicont@CɋLqꂽ^Ŏw肳ꂽWSDDt@CAxisɃfvC܂B
 * 
 * @author koichik
 */
public class WSDDDeployer implements ItemDeployer {
    //class fields
    private final static Logger logger = Logger.getLogger(WSDDDeployer.class);

    //instance fields
    protected AxisDeployer deployer;

    /**
     * CX^X\z܂B
     * 
     * @param deployer
     *            fvC[
     */
    public WSDDDeployer(final AxisDeployer deployer) {
        this.deployer = deployer;
    }

    /**
     * ^Ŏw肳ꂽWSDDt@CfvC܂B
     * 
     * @param componentDef
     *            R|[lg`
     * @param metaDef
     *            ^`
     */
    public void deploy(final ComponentDef componentDef, final MetaDef metaDef) {
        try {
            final Object value = metaDef.getValue();
            if (!(value instanceof String)) {
                throw new DeployFailedException(MessageFormatter.getSimpleMessage("EAXS0002",
                        new Object[] { value }));
            }

            final String wsddFileName = (String) value;
            final InputStream is = ResourceUtil.getResourceAsStream(wsddFileName);
            final WSDDDocument wsddDocument = new WSDDDocument(XMLUtils.newDocument(is));
            wsddDocument.deploy(deployer.getDeployment(metaDef.getContainer()));

            if (logger.isDebugEnabled()) {
                logger.log("DAXS0001", new Object[] { wsddFileName });
            }
        }
        catch (final Exception e) {
            throw new DeployFailedException(e);
        }
    }
}