package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.component.html.HtmlBase;
import org.seasar.jsf.taglib.UIComponentTagBase;

public class HtmlBaseTag extends UIComponentTagBase {

	private String href;
	
	private String target;
	
	public String getHref() {
		return href;
	}
	
	public void setHref(String href) {
		this.href = href;
	}
	
	public String getTarget() {
		return target;
	}
	
	public void setTarget(String target) {
		this.target = target;
	}
	
	public String getComponentType() {
		return HtmlBase.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return HtmlBase.DEFAULT_RENDERER_TYPE;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		HtmlBase base = (HtmlBase) component;
		base.setHref(href);
		base.setTarget(target);
	}
	
	public void release() {
		super.release();
		href = null;
		target = null;
	}
}