/*
*
* The Seasar Software License, Version 1.1
*
* Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
*
* Redistribution and use in source and binary forms, with or
* without modification, are permitted provided that the following
* conditions are met:
*
* 1. Redistributions of source code must retain the above
*    copyright notice, this list of conditions and the following
*    disclaimer.
*
* 2. Redistributions in binary form must reproduce the above
*    copyright notice, this list of conditions and the following
*    disclaimer in the documentation and/or other materials provided
*    with the distribution.
*
* 3. The end-user documentation included with the redistribution,
*    if any, must include the following acknowledgement:
*    "This product includes software developed by the
*    Seasar Project (http://www.seasar.org/)."
*    Alternately, this acknowledgement may appear in the software
*    itself, if and wherever such third-party acknowledgements
*    normally appear.
*
* 4. Neither the name "The Seasar Project" nor the names of its
*    contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission of
*    the Seasar Project.
*
* THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
* PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
* OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
* (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
* INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
* WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
* THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
package org.seasar.remoting.common.interceptor;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.aop.interceptors.MockInterceptor;

/**
 * @author koichik
 */
public class RemotingInterceptorTest extends S2TestCase {
    private MockInterceptor mockInterceptor;

    public RemotingInterceptorTest(String name) {
        super(name);
    }

    public void setUp() {
        include("RemotingInterceptorTest.dicon");
    }

    public void testInvoke() {
        //call concrete method
        Hoge hoge = (Hoge) getComponent(Hoge.class);
        hoge.foo();
        assertFalse(mockInterceptor.isInvoked("invoke"));

        //call abstract method
        hoge.bar();
        assertTrue(mockInterceptor.isInvoked("invoke"));
    }

    public void testGetTargetName() {
        //from name attribute of component
        Hoge hoge = (Hoge) getComponent(Hoge.class);
        hoge.bar();
        Object[] args = mockInterceptor.getArgs("invoke");
        assertEquals("hoge", args[0]);

        //from class attribute of component
        Foo foo = (Foo) getComponent(Foo.class);
        foo.foo();
        args = mockInterceptor.getArgs("invoke");
        assertEquals("RemotingInterceptorTest$Foo", args[0]);

        //from remoteName property
        Bar bar = (Bar) getComponent(Bar.class);
        bar.bar();
        args = mockInterceptor.getArgs("invoke");
        assertEquals("bar", args[0]);
    }

    public interface Hoge {
        void foo();

        void bar();
    }

    public static abstract class HogeImpl implements Hoge {
        public void foo() {
        }
    }

    public interface Foo {
        void foo();
    }

    public interface Bar {
        void bar();
    }
}