package org.seasar.jsf.taglib;

import javax.faces.component.UIComponent;
import javax.faces.webapp.UIComponentTag;

import org.seasar.jsf.component.UIText;

/**
 * @author higa
 *  
 */
public class TextTag extends UIComponentTag {

	private String value;

	public TextTag() {
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}

	public String getComponentType() {
		return UIText.COMPONENT_TYPE;
	}

	public String getRendererType() {
		return UIText.DEFAULT_RENDERER_TYPE;
	}

	/**
	 * @see javax.faces.webapp.UIComponentTag#setProperties(javax.faces.component.UIComponent)
	 */
	protected void setProperties(UIComponent component) {
		UIText text = (UIText) component;
		text.setValue(value);
	}

	/**
	 * @see javax.servlet.jsp.tagext.Tag#release()
	 */
	public void release() {
		super.release();
		value = null;
	}
}