/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.beans.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.exception.EmptyRuntimeException;
import org.seasar.framework.util.BooleanConversionUtil;
import org.seasar.framework.util.ConstructorUtil;
import org.seasar.framework.util.DateConversionUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.NumberConversionUtil;
import org.seasar.framework.util.SqlDateConversionUtil;
import org.seasar.framework.util.TimeConversionUtil;
import org.seasar.framework.util.TimestampConversionUtil;

public final class PropertyDescImpl
implements PropertyDesc {
    private String propertyName_;
    private Class propertyType_;
    private Method readMethod_;
    private Method writeMethod_;
    private BeanDesc beanDesc_;
    private Constructor stringConstructor_;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    public PropertyDescImpl(String propertyName, Class propertyType, Method readMethod, Method writeMethod, BeanDesc beanDesc) {
        if (propertyName == null) {
            throw new EmptyRuntimeException("propertyName");
        }
        if (propertyType == null) {
            throw new EmptyRuntimeException("propertyType");
        }
        this.propertyName_ = propertyName;
        this.propertyType_ = propertyType;
        this.readMethod_ = readMethod;
        this.writeMethod_ = writeMethod;
        this.beanDesc_ = beanDesc;
        this.setupStringConstructor();
    }

    private void setupStringConstructor() {
        Constructor<?>[] cons = this.propertyType_.getConstructors();
        int i = 0;
        while (i < cons.length) {
            Constructor<?> con = cons[i];
            if (con.getParameterTypes().length == 1) {
                Class<?> clazz = con.getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(clazz2)) {
                    this.stringConstructor_ = con;
                    break;
                }
            }
            ++i;
        }
    }

    public final String getPropertyName() {
        return this.propertyName_;
    }

    public final Class getPropertyType() {
        return this.propertyType_;
    }

    public final Method getReadMethod() {
        return this.readMethod_;
    }

    public final void setReadMethod(Method readMethod) {
        this.readMethod_ = readMethod;
    }

    public final boolean hasReadMethod() {
        return this.readMethod_ != null;
    }

    public final Method getWriteMethod() {
        return this.writeMethod_;
    }

    public final void setWriteMethod(Method writeMethod) {
        this.writeMethod_ = writeMethod;
    }

    public final boolean hasWriteMethod() {
        return this.writeMethod_ != null;
    }

    public final Object getValue(Object target) {
        return MethodUtil.invoke(this.readMethod_, target, null);
    }

    public final void setValue(Object target, Object value) {
        try {
            MethodUtil.invoke(this.writeMethod_, target, new Object[]{this.convertIfNeed(value)});
        }
        catch (Throwable t) {
            throw new IllegalPropertyRuntimeException(this.beanDesc_.getBeanClass(), this.propertyName_, t);
        }
    }

    public final BeanDesc getBeanDesc() {
        return this.beanDesc_;
    }

    public final String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("propertyName=");
        buf.append(this.propertyName_);
        buf.append(",propertyType=");
        buf.append(this.propertyType_.getName());
        buf.append(",readMethod=");
        buf.append(this.readMethod_ != null ? this.readMethod_.getName() : "null");
        buf.append(",writeMethod=");
        buf.append(this.writeMethod_ != null ? this.writeMethod_.getName() : "null");
        return buf.toString();
    }

    public Object convertIfNeed(Object arg) {
        if (this.propertyType_.isPrimitive()) {
            return this.convertPrimitiveWrapper(arg);
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(this.propertyType_)) {
            return this.convertNumber(arg);
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.isAssignableFrom(this.propertyType_)) {
            return this.convertDate(arg);
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.isAssignableFrom(this.propertyType_)) {
            return BooleanConversionUtil.toBoolean(arg);
        }
        if (arg instanceof String) {
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz4.equals(this.propertyType_)) {
                return this.convertWithStringConstructor(arg);
            }
        }
        return arg;
    }

    private Object convertPrimitiveWrapper(Object arg) {
        return NumberConversionUtil.convertPrimitiveWrapper(this.propertyType_, arg);
    }

    private Object convertNumber(Object arg) {
        return NumberConversionUtil.convertNumber(this.propertyType_, arg);
    }

    private Object convertDate(Object arg) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.propertyType_ == clazz) {
            return DateConversionUtil.toDate(arg);
        }
        Class<?> clazz2 = class$4;
        if (clazz2 == null) {
            try {
                clazz2 = class$4 = Class.forName("java.sql.Timestamp");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.propertyType_ == clazz2) {
            return TimestampConversionUtil.toTimestamp(arg);
        }
        Class<?> clazz3 = class$5;
        if (clazz3 == null) {
            try {
                clazz3 = class$5 = Class.forName("java.sql.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.propertyType_ == clazz3) {
            return SqlDateConversionUtil.toDate(arg);
        }
        Class<?> clazz4 = class$6;
        if (clazz4 == null) {
            try {
                clazz4 = class$6 = Class.forName("java.sql.Time");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (this.propertyType_ == clazz4) {
            return TimeConversionUtil.toTime(arg);
        }
        return arg;
    }

    private Object convertWithStringConstructor(Object arg) {
        if (this.stringConstructor_ == null || arg == null) {
            return arg;
        }
        return ConstructorUtil.newInstance(this.stringConstructor_, new Object[]{arg});
    }
}

