/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.util;

import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.seasar.framework.container.S2Container;

public class BindingUtil {
    private BindingUtil() {
    }

    public static boolean isValueReference(String value) {
        if (value == null) {
            return false;
        }
        int start = value.indexOf("#{");
        if (start < 0) {
            return false;
        }
        int end = value.lastIndexOf(125);
        return end >= 0 && start < end;
    }

    public static Object getValue(S2Container container, String name) {
        HttpServletRequest request = container.getRequest();
        Object var = BindingUtil.getValue(request, name);
        if (var != null) {
            return var;
        }
        if (container.hasComponentDef((Object)name)) {
            return container.getComponent((Object)name);
        }
        return null;
    }

    public static Object getValue(HttpServletRequest request, String name) {
        Object var = request.getAttribute(name);
        if (var != null) {
            return var;
        }
        var = request.getParameter(name);
        if (var != null && !"null".equals(var)) {
            return var;
        }
        var = request.getAttribute(name);
        if (var != null) {
            return var;
        }
        HttpSession session = request.getSession(false);
        if (session != null && (var = session.getAttribute(name)) != null) {
            return var;
        }
        return null;
    }

    public static Object getBindingValue(UIComponent component, String propertyName) {
        ValueBinding binding = component.getValueBinding(propertyName);
        if (binding != null) {
            FacesContext ctx = FacesContext.getCurrentInstance();
            return binding.getValue(ctx);
        }
        return null;
    }

    public static void setValueBinding(UIComponent component, String name, String value) {
        FacesContext ctx = FacesContext.getCurrentInstance();
        Application app = ctx.getApplication();
        ValueBinding binding = app.createValueBinding(value);
        component.setValueBinding(name, binding);
    }
}

