package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.S2UISelectItems;
import org.seasar.jsf.exception.NoValueReferenceRuntimeException;
import org.seasar.jsf.util.BindingUtil;

public abstract class HtmlSelectTagBase extends HtmlInputTagBase {
	
	private String border;
	
	private String disabledClass;

	private String enabledClass;
	
	private String items;
	
	private String itemLabel;
	
	private String itemValue;
	
	private String layout;
	
	private String nullLabel;

	public void setBorder(String border) {
		this.border = border;
	}
	
	public void setDisabledClass(String disabledClass) {
		this.disabledClass = disabledClass;
	}

	public void setEnabledClass(String enabledClass) {
		this.enabledClass = enabledClass;
	}
	
	public void setItems(String items) {
		this.items = items;
	}
	
	public void setItemLabel(String itemLabel) {
		this.itemLabel = itemLabel;
	}
	
	public void setItemValue(String itemValue) {
		this.itemValue = itemValue;
	}
	
	public void setLayout(String layout) {
		this.layout = layout;
	}
	
	public void setNullLabel(String nullLabel) {
		this.nullLabel = nullLabel;
	}
	
	public void release() {
		super.release();
		border = null;
		disabledClass = null;
		enabledClass = null;
		items = null;
		itemLabel = null;
		itemValue = null;
		layout = null;
		nullLabel = null;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.BORDER_ATTR, border);
		setComponentProperty(component, JsfConstants.DISABLED_CLASS_ATTR,
				disabledClass);
		setComponentProperty(component, JsfConstants.ENABLED_CLASS_ATTR, enabledClass);
		setComponentProperty(component, JsfConstants.LAYOUT_ATTR, layout);
		if (items != null) {
			if (!isValueReference(items)) {
				throw new NoValueReferenceRuntimeException(items);
			}
			S2UISelectItems child = new S2UISelectItems();
			BindingUtil.setValueBinding(child, JsfConstants.VALUE_ATTR, items);
			if (itemValue != null) {
				child.setItemValue(itemValue);
			}
			if (itemLabel != null) {
				child.setItemLabel(itemLabel);
			}
			if (nullLabel != null) {
				child.setNullLabel(nullLabel);
			}
			component.getChildren().add(child);
		}
	}
}