package org.seasar.jsf.runtime;

import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * @author higa
 *  
 */
public class ClassLoaderTaglibManagerImpl extends AbstractTaglibManager {

	public void init() {
		scanJars(getClass().getClassLoader());
	}

	public void scanJars(ClassLoader classLoader) {
		while (classLoader != null) {
			if (classLoader instanceof URLClassLoader) {
				URL[] urls = ((URLClassLoader) classLoader).getURLs();
				for (int i = 0; i < urls.length; ++i) {
					JarURLConnection conn = openJarURLConnection(urls[i]);
					if (conn != null) {
						scanJar(conn);
					}
				}
			}
			classLoader = classLoader.getParent();
		}
	}
}