/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.framework.aop.javassist;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import org.seasar.framework.aop.javassist.CannotCompileRuntimeException;
import org.seasar.framework.aop.javassist.NotFoundRuntimeException;
import org.seasar.framework.util.ClassUtil;

public class AbstractGenerator {
    protected final ClassPool classPool;
    static /* synthetic */ Class class$0;

    protected AbstractGenerator(ClassPool classPool) {
        this.classPool = classPool;
    }

    protected CtClass toCtClass(Class clazz) {
        return this.toCtClass(ClassUtil.getSimpleClassName(clazz));
    }

    protected CtClass toCtClass(String className) {
        try {
            return this.classPool.get(className);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected CtClass[] toCtClassArray(String[] classNames) {
        CtClass[] result = new CtClass[classNames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.toCtClass(classNames[i]);
            ++i;
        }
        return result;
    }

    protected CtClass[] toCtClassArray(Class[] classes) {
        CtClass[] result = new CtClass[classes.length];
        int i = 0;
        while (i < result.length) {
            result[i] = this.toCtClass(classes[i]);
            ++i;
        }
        return result;
    }

    protected CtClass createCtClass(String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return this.createCtClass(name, clazz);
    }

    protected CtClass createCtClass(String name, Class superClass) {
        return this.createCtClass(name, this.toCtClass(superClass));
    }

    protected CtClass createCtClass(String name, CtClass superClass) {
        return this.classPool.makeClass(name, superClass);
    }

    protected CtClass getAndRenameCtClass(Class orgClass, String newName) {
        return this.getAndRenameCtClass(ClassUtil.getSimpleClassName(orgClass), newName);
    }

    protected CtClass getAndRenameCtClass(String orgName, String newName) {
        try {
            return this.classPool.getAndRename(orgName, newName);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected static Class toClass(ClassLoader classLoader, CtClass clazz) {
        try {
            return clazz.toClass(classLoader);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void setInterface(CtClass clazz, Class interfaceType) {
        clazz.setInterfaces(new CtClass[]{this.toCtClass(interfaceType)});
    }

    protected void setInterfaces(CtClass clazz, Class[] interfaces) {
        clazz.setInterfaces(this.toCtClassArray(interfaces));
    }

    protected CtConstructor createDefaultConstructor(Class clazz) {
        return this.createDefaultConstructor(this.toCtClass(clazz));
    }

    protected CtConstructor createDefaultConstructor(CtClass clazz) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.defaultConstructor((CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtConstructor createConstructor(CtClass clazz, Constructor constructor) {
        return this.createConstructor(clazz, this.toCtClassArray(constructor.getParameterTypes()), this.toCtClassArray(constructor.getExceptionTypes()));
    }

    protected CtConstructor createConstructor(CtClass clazz, CtClass[] parameterTypes, CtClass[] exceptionTypes) {
        try {
            CtConstructor ctConstructor = CtNewConstructor.make((CtClass[])parameterTypes, (CtClass[])exceptionTypes, (CtClass)clazz);
            clazz.addConstructor(ctConstructor);
            return ctConstructor;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod getDeclaredMethod(CtClass clazz, String name, CtClass[] argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NotFoundException e) {
            throw new NotFoundRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, String src) {
        try {
            CtMethod ctMethod = CtNewMethod.make((String)src, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected CtMethod createMethod(CtClass clazz, Method method, String body) {
        return this.createMethod(clazz, method.getModifiers(), method.getReturnType(), method.getName(), method.getParameterTypes(), method.getExceptionTypes(), body);
    }

    protected CtMethod createMethod(CtClass clazz, int modifier, Class returnType, String methodName, Class[] parameterTypes, Class[] exceptionTypes, String body) {
        try {
            CtMethod ctMethod = CtNewMethod.make((int)(modifier & 0xFFFFFAFF), (CtClass)this.toCtClass(returnType), (String)methodName, (CtClass[])this.toCtClassArray(parameterTypes), (CtClass[])this.toCtClassArray(exceptionTypes), (String)body, (CtClass)clazz);
            clazz.addMethod(ctMethod);
            ctMethod.setBody(body);
            return ctMethod;
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }

    protected void setMethodBody(CtMethod method, String src) {
        try {
            method.setBody(src);
        }
        catch (CannotCompileException e) {
            throw new CannotCompileRuntimeException(e);
        }
    }
}

