package org.seasar.extension.mock.servlet;

import javax.servlet.http.HttpSession;

import org.seasar.framework.util.ClassUtil;
/**
 * @author Satoshi Kimura
 */
public interface MockHttpSession extends HttpSession {
    String METHOD_NAME_IS_VALID = ClassUtil.getMethod(MockHttpSession.class, "isValid", null).getName();
    String METHOD_NAME_SET_VALID = ClassUtil.getMethod(MockHttpSession.class, "setValid", new Class[]{Boolean.TYPE})
            .getName();

    /**
     * {@link MockHttpSession#invalidate()}Ă΂ꂽmF܂B
     * 
     * @return Ă΂ꂽꍇFtrueAĂ΂ĂȂꍇFfalse
     */
    boolean isValid();

    /**
     * {@link MockHttpSession#invalidate()}Ă΂ꂽƂɁAIɁÃ\bhĂт܂B
     * 
     * @param valid {@link MockHttpSession#invalidate()}Ă΂ꂽƂɁAtrue
     */
    void setValid(boolean valid);
    
    void access();
}