package org.seasar.jsf.runtime;

import java.util.ArrayList;
import java.util.List;

import org.seasar.jsf.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class TagSelectors {

	private List tagSelectors = new ArrayList();

	public TagSelectors() {
	}

	public TagSelector getTagSelector(String namespaceURI, String localName,
			String qName, Attributes attributes) {
		
		for (int i = 0; i < tagSelectors.size(); ++i) {
			TagSelector factory = (TagSelector) tagSelectors.get(i);
			if (factory.isSelectable(namespaceURI, localName,
					qName, attributes)) {

				return factory;
			}
		}
		return null;
	}

	public void addTagSelector(TagSelector tagSelector) {
		tagSelectors.add(tagSelector);
	}
}