/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.convert;

import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert._MessageUtils;

public class ShortConverter
implements Converter {
    private static final String CONVERSION_MESSAGE_ID = "javax.faces.convert.ShortConverter.CONVERSION";
    public static final String CONVERTER_ID = "javax.faces.Short";

    public Object getAsObject(FacesContext facesContext, UIComponent uiComponent, String value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value != null && (value = value.trim()).length() > 0) {
            try {
                return Short.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new ConverterException(_MessageUtils.getErrorMessage(facesContext, CONVERSION_MESSAGE_ID, new Object[]{uiComponent.getId(), value}), (Throwable)e);
            }
        }
        return null;
    }

    public String getAsString(FacesContext facesContext, UIComponent uiComponent, Object value) {
        if (facesContext == null) {
            throw new NullPointerException("facesContext");
        }
        if (uiComponent == null) {
            throw new NullPointerException("uiComponent");
        }
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        try {
            return Short.toString(((Number)value).shortValue());
        }
        catch (Exception e) {
            throw new ConverterException(e);
        }
    }
}

