/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.dao.impl;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.seasar.dao.BeanMetaData;
import org.seasar.dao.DaoMetaData;
import org.seasar.dao.DaoNotFoundRuntimeException;
import org.seasar.dao.Dbms;
import org.seasar.dao.IllegalSignatureRuntimeException;
import org.seasar.dao.SqlCommand;
import org.seasar.dao.dbms.DbmsManager;
import org.seasar.dao.impl.AbstractAutoStaticCommand;
import org.seasar.dao.impl.BeanArrayMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanListMetaDataResultSetHandler;
import org.seasar.dao.impl.BeanMetaDataImpl;
import org.seasar.dao.impl.BeanMetaDataResultSetHandler;
import org.seasar.dao.impl.DeleteAutoStaticCommand;
import org.seasar.dao.impl.DeleteBatchAutoStaticCommand;
import org.seasar.dao.impl.DtoMetaDataImpl;
import org.seasar.dao.impl.InsertAutoStaticCommand;
import org.seasar.dao.impl.InsertBatchAutoStaticCommand;
import org.seasar.dao.impl.SelectDynamicCommand;
import org.seasar.dao.impl.UpdateAutoStaticCommand;
import org.seasar.dao.impl.UpdateBatchAutoStaticCommand;
import org.seasar.dao.impl.UpdateDynamicCommand;
import org.seasar.extension.jdbc.CallableStatementFactory;
import org.seasar.extension.jdbc.PropertyType;
import org.seasar.extension.jdbc.ResultSetFactory;
import org.seasar.extension.jdbc.ResultSetHandler;
import org.seasar.extension.jdbc.impl.ObjectResultSetHandler;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.MethodNotFoundRuntimeException;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.ConnectionUtil;
import org.seasar.framework.util.DataSourceUtil;
import org.seasar.framework.util.FieldUtil;
import org.seasar.framework.util.MethodUtil;
import org.seasar.framework.util.ResourceUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.framework.util.TextUtil;

public class DaoMetaDataImpl
implements DaoMetaData {
    private static final String[] INSERT_NAMES = new String[]{"insert", "create", "add"};
    private static final String[] UPDATE_NAMES = new String[]{"update", "modify", "store"};
    private static final String[] DELETE_NAMES = new String[]{"delete", "remove"};
    private Class daoClass_;
    private BeanDesc daoBeanDesc_;
    private DataSource dataSource_;
    private CallableStatementFactory callableStatementFactory_;
    private ResultSetFactory resultSetFactory_;
    private Dbms dbms_;
    private Class beanClass_;
    private BeanMetaData beanMetaData_;
    private Map sqlCommands_ = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DaoMetaDataImpl(Class daoClass, DataSource dataSource, CallableStatementFactory callableStatementFactory, ResultSetFactory resultSetFactory) {
        this.daoClass_ = daoClass;
        this.daoBeanDesc_ = BeanDescFactory.getBeanDesc((Class)daoClass);
        Field beanField = this.daoBeanDesc_.getField("BEAN");
        this.beanClass_ = (Class)FieldUtil.get((Field)beanField, null);
        this.dataSource_ = dataSource;
        this.callableStatementFactory_ = callableStatementFactory;
        this.resultSetFactory_ = resultSetFactory;
        Connection con = DataSourceUtil.getConnection((DataSource)this.dataSource_);
        try {
            DatabaseMetaData dbMetaData = ConnectionUtil.getMetaData((Connection)con);
            this.dbms_ = DbmsManager.getDbms(dbMetaData);
            this.beanMetaData_ = new BeanMetaDataImpl(this.beanClass_, dbMetaData, this.dbms_);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ConnectionUtil.close((Connection)con);
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        ConnectionUtil.close((Connection)con);
        this.setupSqlCommand();
    }

    private void setupSqlCommand() {
        String[] names = this.daoBeanDesc_.getMethodNames();
        int i = 0;
        while (i < names.length) {
            Method[] methods = this.daoBeanDesc_.getMethods(names[i]);
            if (methods.length == 1 && MethodUtil.isAbstract((Method)methods[0])) {
                this.setupMethod(methods[0]);
            }
            ++i;
        }
    }

    private void setupMethod(Method method) {
        String base = String.valueOf(this.daoClass_.getName().replace('.', '/')) + "_" + method.getName();
        String dbmsPath = String.valueOf(base) + this.dbms_.getSuffix() + ".sql";
        String standardPath = String.valueOf(base) + ".sql";
        if (ResourceUtil.isExist((String)dbmsPath)) {
            String sql = TextUtil.readText((String)dbmsPath);
            this.setupMethodByManual(method, sql);
        } else if (ResourceUtil.isExist((String)standardPath)) {
            String sql = TextUtil.readText((String)standardPath);
            this.setupMethodByManual(method, sql);
        } else {
            this.setupMethodByAuto(method);
        }
    }

    private void setupMethodByManual(Method method, String sql) {
        if (this.isSelect(method)) {
            this.setupSelectMethodByManual(method, sql);
        } else {
            this.setupUpdateMethodByManual(method, sql);
        }
    }

    private void setupMethodByAuto(Method method) {
        if (this.isInsert(method.getName())) {
            this.setupInsertMethodByAuto(method);
        } else if (this.isUpdate(method.getName())) {
            this.setupUpdateMethodByAuto(method);
        } else if (this.isDelete(method.getName())) {
            this.setupDeleteMethodByAuto(method);
        } else {
            this.setupSelectMethodByAuto(method);
        }
    }

    private void setupSelectMethodByManual(Method method, String sql) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(this.createResultSetHandler(method));
        cmd.setSql(sql);
        cmd.setArgNames(this.getArgNames(method.getName()));
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler rsh) {
        return new SelectDynamicCommand(this.dataSource_, this.callableStatementFactory_, rsh, this.resultSetFactory_);
    }

    private SelectDynamicCommand createSelectDynamicCommand(ResultSetHandler resultSetHandler, String query) {
        SelectDynamicCommand cmd = this.createSelectDynamicCommand(resultSetHandler);
        StringBuffer buf = new StringBuffer(255);
        if (DaoMetaDataImpl.startsWithSelect(query)) {
            buf.append(query);
        } else {
            String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
            buf.append(sql);
            if (query != null) {
                if (DaoMetaDataImpl.startsWithOrderBy(query)) {
                    buf.append(" ");
                } else if (sql.lastIndexOf("WHERE") < 0) {
                    buf.append(" WHERE ");
                } else {
                    buf.append(" AND ");
                }
                buf.append(query);
            }
        }
        cmd.setSql(buf.toString());
        return cmd;
    }

    private static boolean startsWithSelect(String query) {
        return StringUtil.startsWith((String)query, (String)"select");
    }

    private static boolean startsWithOrderBy(String query) {
        return StringUtil.startsWith((String)query, (String)"order by");
    }

    private ResultSetHandler createResultSetHandler(Method method) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.util.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.isAssignableFrom(method.getReturnType())) {
            return new BeanListMetaDataResultSetHandler(this.beanMetaData_);
        }
        if (this.isBeanClassAssignable(method.getReturnType())) {
            return new BeanMetaDataResultSetHandler(this.beanMetaData_);
        }
        if (Array.newInstance(this.beanClass_, 0).getClass().isAssignableFrom(method.getReturnType())) {
            return new BeanArrayMetaDataResultSetHandler(this.beanMetaData_);
        }
        return new ObjectResultSetHandler();
    }

    private boolean isBeanClassAssignable(Class clazz) {
        return this.beanClass_.isAssignableFrom(clazz) || clazz.isAssignableFrom(this.beanClass_);
    }

    private void setupUpdateMethodByManual(Method method, String sql) {
        UpdateDynamicCommand cmd = new UpdateDynamicCommand(this.dataSource_, this.callableStatementFactory_);
        cmd.setSql(sql);
        String[] argNames = this.getArgNames(method.getName());
        if (argNames.length == 0 && this.isUpdateSignatureForBean(method)) {
            argNames = new String[]{StringUtil.decapitalize((String)ClassUtil.getShortClassName((Class)this.beanClass_))};
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private boolean isUpdateSignatureForBean(Method method) {
        return method.getParameterTypes().length == 1 && this.isBeanClassAssignable(method.getParameterTypes()[0]);
    }

    private void setupInsertMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new InsertAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames) : new InsertBatchAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private void setupUpdateMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new UpdateAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames) : new UpdateBatchAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private void setupDeleteMethodByAuto(Method method) {
        this.checkAutoUpdateMethod(method);
        String[] propertyNames = this.getPersistentPropertyNames(method.getName());
        AbstractAutoStaticCommand cmd = null;
        cmd = this.isUpdateSignatureForBean(method) ? new DeleteAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames) : new DeleteBatchAutoStaticCommand(this.dataSource_, this.callableStatementFactory_, this.beanMetaData_, propertyNames);
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private String[] getPersistentPropertyNames(String methodName) {
        int i;
        String[] props;
        String s;
        Field field;
        ArrayList<String> names = new ArrayList<String>();
        String fieldName = String.valueOf(methodName) + "_NO_PERSISTENT_PROPS";
        if (this.daoBeanDesc_.hasField(fieldName)) {
            field = this.daoBeanDesc_.getField(fieldName);
            s = (String)FieldUtil.get((Field)field, null);
            props = StringUtil.split((String)s, (String)", ");
            i = 0;
            while (i < this.beanMetaData_.getPropertyTypeSize()) {
                PropertyType pt = this.beanMetaData_.getPropertyType(i);
                if (pt.isPersistent() && !this.isPropertyExist(props, pt.getPropertyName())) {
                    names.add(pt.getPropertyName());
                }
                ++i;
            }
        } else {
            fieldName = String.valueOf(methodName) + "_PERSISTENT_PROPS";
            if (this.daoBeanDesc_.hasField(fieldName)) {
                field = this.daoBeanDesc_.getField(fieldName);
                s = (String)FieldUtil.get((Field)field, null);
                props = StringUtil.split((String)s, (String)", ");
                names.addAll(Arrays.asList(props));
                i = 0;
                while (i < this.beanMetaData_.getPrimaryKeySize()) {
                    String pk = this.beanMetaData_.getPrimaryKey(i);
                    PropertyType pt = this.beanMetaData_.getPropertyTypeByColumnName(pk);
                    names.add(pt.getPropertyName());
                    ++i;
                }
                if (this.beanMetaData_.hasVersionNoPropertyType()) {
                    names.add(this.beanMetaData_.getVersionNoPropertyName());
                }
                if (this.beanMetaData_.hasTimestampPropertyType()) {
                    names.add(this.beanMetaData_.getTimestampPropertyName());
                }
            }
        }
        if (names.size() == 0) {
            int i2 = 0;
            while (i2 < this.beanMetaData_.getPropertyTypeSize()) {
                PropertyType pt = this.beanMetaData_.getPropertyType(i2);
                if (pt.isPersistent()) {
                    names.add(pt.getPropertyName());
                }
                ++i2;
            }
        }
        return names.toArray(new String[names.size()]);
    }

    private boolean isPropertyExist(String[] props, String propertyName) {
        int i = 0;
        while (i < props.length) {
            if (props[i].equalsIgnoreCase(propertyName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void setupSelectMethodByAuto(Method method) {
        String query = this.getQuery(method.getName());
        ResultSetHandler handler = this.createResultSetHandler(method);
        SelectDynamicCommand cmd = null;
        String[] argNames = this.getArgNames(method.getName());
        if (query != null && !DaoMetaDataImpl.startsWithOrderBy(query)) {
            cmd = this.createSelectDynamicCommand(handler, query);
        } else {
            cmd = this.createSelectDynamicCommand(handler);
            String sql = null;
            if (argNames.length == 0 && method.getParameterTypes().length == 1) {
                argNames = new String[]{"dto"};
                sql = this.createAutoSelectSqlByDto(method.getParameterTypes()[0]);
            } else {
                sql = this.createAutoSelectSql(argNames);
            }
            if (query != null) {
                sql = String.valueOf(sql) + " " + query;
            }
            cmd.setSql(sql);
        }
        cmd.setArgNames(argNames);
        cmd.setArgTypes(method.getParameterTypes());
        this.sqlCommands_.put(method.getName(), cmd);
    }

    private String createAutoSelectSqlByDto(Class dtoClass) {
        String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        DtoMetaDataImpl dmd = new DtoMetaDataImpl(dtoClass);
        boolean began = false;
        if (sql.lastIndexOf("WHERE") <= 0) {
            buf.append("/*BEGIN*/ WHERE ");
            began = true;
        }
        int i = 0;
        while (i < dmd.getPropertyTypeSize()) {
            PropertyType pt = dmd.getPropertyType(i);
            String aliasName = pt.getColumnName();
            if (this.beanMetaData_.hasPropertyTypeByAliasName(aliasName) && this.beanMetaData_.getPropertyTypeByAliasName(aliasName).isPersistent()) {
                String columnName = this.beanMetaData_.convertFullColumnName(aliasName);
                String propertyName = "dto." + pt.getPropertyName();
                buf.append("/*IF ");
                buf.append(propertyName);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(propertyName);
                buf.append("*/null");
                buf.append("/*END*/");
            }
            ++i;
        }
        if (began) {
            buf.append("/*END*/");
        }
        return buf.toString();
    }

    private String createAutoSelectSql(String[] argNames) {
        String sql = this.dbms_.getAutoSelectSql(this.getBeanMetaData());
        StringBuffer buf = new StringBuffer(sql);
        if (argNames.length != 0) {
            boolean began = false;
            if (sql.lastIndexOf("WHERE") <= 0) {
                buf.append("/*BEGIN*/ WHERE ");
                began = true;
            }
            int i = 0;
            while (i < argNames.length) {
                String columnName = this.beanMetaData_.convertFullColumnName(argNames[i]);
                buf.append("/*IF ");
                buf.append(argNames[i]);
                buf.append(" != null*/");
                buf.append(" ");
                if (!began || i != 0) {
                    buf.append("AND ");
                }
                buf.append(columnName);
                buf.append(" = /*");
                buf.append(argNames[i]);
                buf.append("*/null");
                buf.append("/*END*/");
                ++i;
            }
            if (began) {
                buf.append("/*END*/");
            }
        }
        return buf.toString();
    }

    private void checkAutoUpdateMethod(Method method) {
        block8: {
            block7: {
                if (method.getParameterTypes().length != 1) break block7;
                if (this.isBeanClassAssignable(method.getParameterTypes()[0])) break block8;
                Class<?> clazz = method.getParameterTypes()[0];
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("java.util.List");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.isAssignableFrom(clazz2) || method.getParameterTypes()[0].isArray()) break block8;
            }
            throw new IllegalSignatureRuntimeException("EDAO0006", method.toString());
        }
    }

    private boolean isSelect(Method method) {
        if (this.isInsert(method.getName())) {
            return false;
        }
        if (this.isUpdate(method.getName())) {
            return false;
        }
        return !this.isDelete(method.getName());
    }

    private boolean isInsert(String methodName) {
        int i = 0;
        while (i < INSERT_NAMES.length) {
            if (methodName.startsWith(INSERT_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isUpdate(String methodName) {
        int i = 0;
        while (i < UPDATE_NAMES.length) {
            if (methodName.startsWith(UPDATE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isDelete(String methodName) {
        int i = 0;
        while (i < DELETE_NAMES.length) {
            if (methodName.startsWith(DELETE_NAMES[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String[] getArgNames(String methodName) {
        String argsKey = String.valueOf(methodName) + "_ARGS";
        if (this.daoBeanDesc_.hasField(argsKey)) {
            Field argNamesField = this.daoBeanDesc_.getField(argsKey);
            String argNames = (String)FieldUtil.get((Field)argNamesField, null);
            return StringUtil.split((String)argNames, (String)" ,");
        }
        return new String[0];
    }

    private String getQuery(String methodName) {
        String key = String.valueOf(methodName) + "_QUERY";
        if (this.daoBeanDesc_.hasField(key)) {
            Field queryField = this.daoBeanDesc_.getField(key);
            return (String)FieldUtil.get((Field)queryField, null);
        }
        return null;
    }

    public Class getBeanClass() {
        return this.daoClass_;
    }

    public BeanMetaData getBeanMetaData() {
        return this.beanMetaData_;
    }

    public SqlCommand getSqlCommand(String methodName) throws MethodNotFoundRuntimeException {
        SqlCommand cmd = (SqlCommand)this.sqlCommands_.get(methodName);
        if (cmd == null) {
            throw new MethodNotFoundRuntimeException(this.daoClass_, methodName, null);
        }
        return cmd;
    }

    public boolean hasSqlCommand(String methodName) {
        return this.sqlCommands_.containsKey(methodName);
    }

    public SqlCommand createFindCommand(String query) {
        return this.createSelectDynamicCommand(new BeanListMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindArrayCommand(String query) {
        return this.createSelectDynamicCommand(new BeanArrayMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindBeanCommand(String query) {
        return this.createSelectDynamicCommand(new BeanMetaDataResultSetHandler(this.beanMetaData_), query);
    }

    public SqlCommand createFindObjectCommand(String query) {
        return this.createSelectDynamicCommand((ResultSetHandler)new ObjectResultSetHandler(), query);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Class getDaoInterface(Class clazz) {
        Class<?> clazz2;
        if (clazz.isInterface()) {
            return clazz;
        }
        Class target = clazz;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                Class<?>[] interfaces = target.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    Class<?> intf = interfaces[i];
                    if (intf.getName().endsWith("Dao")) {
                        return intf;
                    }
                    ++i;
                }
                target = target.getSuperclass();
            }
            if ((clazz2 = class$1) != null) continue;
            try {
                clazz2 = Class.forName("org.seasar.dao.impl.AbstractDao");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (target != clazz2);
        throw new DaoNotFoundRuntimeException(clazz);
    }

    public void setDbms(Dbms dbms) {
        this.dbms_ = dbms;
    }
}

