package org.seasar.extension.jdbc.impl;

import java.sql.CallableStatement;
import java.sql.Connection;

import org.seasar.extension.jdbc.CallableStatementFactory;
import org.seasar.framework.util.ConnectionUtil;

/**
 * @author higa
 *
 */
public class BooleanToIntCallableStatementFactory implements CallableStatementFactory {
	
	public static final CallableStatementFactory INSTANCE = new BooleanToIntCallableStatementFactory();
	
	/**
	 * @see org.seasar.extension.jdbc.CallableStatementFactory#createCallableStatement(java.sql.Connection, java.lang.String)
	 */
	public CallableStatement createCallableStatement(Connection con, String sql) {
		return new BooleanToIntCallableStatement(ConnectionUtil.prepareCall(con, sql));
	}
}
