package org.seasar.jsf.el;

import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.MethodBinding;
import javax.faces.el.MethodNotFoundException;

/**
 * @author higa
 *  
 */

public class SimpleMethodBinding extends MethodBinding implements StateHolder {

	private String outcome_;
	private boolean transient_ = false;

	public SimpleMethodBinding() {
	}
	
	public SimpleMethodBinding(String outcome) {
		outcome_ = outcome;
	}

	public Object invoke(FacesContext context, Object args[])
			throws EvaluationException, MethodNotFoundException {

		return outcome_;
	}

	public Class getType(FacesContext context) throws MethodNotFoundException {
		return String.class;
	}

	public Object saveState(FacesContext context) {
		return outcome_;
	}

	public void restoreState(FacesContext context, Object obj) {
		outcome_ = (String) obj;
	}

	public boolean isTransient() {
		return transient_;
	}

	public void setTransient(boolean b) {
		transient_ = b;
	}
}