/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.context.servlet;

import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public abstract class AbstractAttributeMap
implements Map {
    private Set _keySet;
    private Collection _values;
    private Set _entrySet;

    public void clear() {
        ArrayList names = new ArrayList();
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            names.add(e.nextElement());
        }
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.removeAttribute((String)it.next());
        }
    }

    public boolean containsKey(Object key) {
        return this.getAttribute(key.toString()) != null;
    }

    public boolean containsValue(Object findValue) {
        if (findValue == null) {
            return false;
        }
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            Object value = this.getAttribute((String)e.nextElement());
            if (!findValue.equals(value)) continue;
            return true;
        }
        return false;
    }

    public Set entrySet() {
        return this._entrySet != null ? this._entrySet : (this._entrySet = new EntrySet());
    }

    public Object get(Object key) {
        return this.getAttribute(key.toString());
    }

    public boolean isEmpty() {
        return !this.getAttributeNames().hasMoreElements();
    }

    public Set keySet() {
        return this._keySet != null ? this._keySet : (this._keySet = new KeySet());
    }

    public Object put(Object key, Object value) {
        String key_ = key.toString();
        Object retval = this.getAttribute(key_);
        this.setAttribute(key_, value);
        return retval;
    }

    public void putAll(Map t) {
        Iterator it = t.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            this.setAttribute(entry.getKey().toString(), entry.getValue());
        }
    }

    public Object remove(Object key) {
        String key_ = key.toString();
        Object retval = this.getAttribute(key_);
        this.removeAttribute(key_);
        return retval;
    }

    public int size() {
        int size = 0;
        Enumeration e = this.getAttributeNames();
        while (e.hasMoreElements()) {
            ++size;
            e.nextElement();
        }
        return size;
    }

    public Collection values() {
        return this._values != null ? this._values : (this._values = new Values());
    }

    protected abstract Object getAttribute(String var1);

    protected abstract void setAttribute(String var1, Object var2);

    protected abstract void removeAttribute(String var1);

    protected abstract Enumeration getAttributeNames();

    private class EntrySetEntry
    implements Map.Entry {
        private final Object _currentKey;

        public EntrySetEntry(Object currentKey) {
            this._currentKey = currentKey;
        }

        public Object getKey() {
            return this._currentKey;
        }

        public Object getValue() {
            return AbstractAttributeMap.this.get(this._currentKey);
        }

        public Object setValue(Object value) {
            return AbstractAttributeMap.this.put(this._currentKey, value);
        }
    }

    private class EntryIterator
    extends KeyIterator {
        private EntryIterator() {
        }

        public Object next() {
            super.next();
            return new EntrySetEntry(this._currentKey);
        }
    }

    private class EntrySet
    extends KeySet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new EntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) {
                return false;
            }
            return value.equals(AbstractAttributeMap.this.get(key));
        }

        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)o;
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null || !value.equals(AbstractAttributeMap.this.get(key))) {
                return false;
            }
            return AbstractAttributeMap.this.remove(((Map.Entry)o).getKey()) != null;
        }
    }

    private class ValuesIterator
    extends KeyIterator {
        private ValuesIterator() {
        }

        public Object next() {
            super.next();
            return AbstractAttributeMap.this.get(this._currentKey);
        }
    }

    private class Values
    extends KeySet {
        private Values() {
        }

        public Iterator iterator() {
            return new ValuesIterator();
        }

        public boolean contains(Object o) {
            return AbstractAttributeMap.this.containsValue(o);
        }

        public boolean remove(Object o) {
            if (o == null) {
                return false;
            }
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!o.equals(it.next())) continue;
                it.remove();
                return true;
            }
            return false;
        }
    }

    private class KeyIterator
    implements Iterator {
        protected final Enumeration _e;
        protected Object _currentKey;

        private KeyIterator() {
            this._e = AbstractAttributeMap.this.getAttributeNames();
        }

        public void remove() {
            if (this._currentKey == null) {
                throw new NoSuchElementException("You must call next() at least once");
            }
            AbstractAttributeMap.this.remove(this._currentKey);
        }

        public boolean hasNext() {
            return this._e.hasMoreElements();
        }

        public Object next() {
            this._currentKey = this._e.nextElement();
            return this._currentKey;
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public boolean isEmpty() {
            return AbstractAttributeMap.this.isEmpty();
        }

        public int size() {
            return AbstractAttributeMap.this.size();
        }

        public boolean contains(Object o) {
            return AbstractAttributeMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return AbstractAttributeMap.this.remove(o) != null;
        }

        public void clear() {
            AbstractAttributeMap.this.clear();
        }
    }
}

