/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sourceforge.myfaces.util.HashMapUtils;

public abstract class BiLevelCacheMap
implements Map {
    private static final int INITIAL_SIZE_L1 = 32;
    protected Map _cacheL1 = new HashMap(32);
    private final Map _cacheL2;
    private final int _mergeThreshold;
    private int _missCount;

    public BiLevelCacheMap(int mergeThreshold) {
        this._cacheL2 = new HashMap(HashMapUtils.calcCapacity(mergeThreshold));
        this._mergeThreshold = mergeThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Map map = this._cacheL2;
        synchronized (map) {
            return this._cacheL1.isEmpty() && this._cacheL2.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this._cacheL2;
        synchronized (map) {
            this._cacheL1 = new HashMap();
            this._cacheL2.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Object key) {
        Map map = this._cacheL2;
        synchronized (map) {
            return this._cacheL1.containsKey(key) || this._cacheL2.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Map map = this._cacheL2;
        synchronized (map) {
            return this._cacheL1.containsValue(value) || this._cacheL2.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set entrySet() {
        Map map = this._cacheL2;
        synchronized (map) {
            this.mergeIfL2NotEmpty();
            return Collections.unmodifiableSet(this._cacheL1.entrySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        Map cacheL1 = this._cacheL1;
        Object retval = cacheL1.get(key);
        if (retval != null) {
            return retval;
        }
        Map map = this._cacheL2;
        synchronized (map) {
            if (cacheL1 != this._cacheL1 && (retval = this._cacheL1.get(key)) != null) {
                return retval;
            }
            retval = this._cacheL2.get(key);
            if (retval == null) {
                retval = this.newInstance(key);
                if (retval != null) {
                    this.put(key, retval);
                    this.mergeIfNeeded();
                }
            } else {
                this.mergeIfNeeded();
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set keySet() {
        Map map = this._cacheL2;
        synchronized (map) {
            this.mergeIfL2NotEmpty();
            return Collections.unmodifiableSet(this._cacheL1.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object key, Object value) {
        Map map = this._cacheL2;
        synchronized (map) {
            this._cacheL2.put(key, value);
            this.mergeIfNeeded();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Map map2 = this._cacheL2;
        synchronized (map2) {
            this.mergeIfL2NotEmpty();
            this.merge(map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(Object key) {
        Map map = this._cacheL2;
        synchronized (map) {
            Object retval;
            HashMap newMap;
            if (!this._cacheL1.containsKey(key) && !this._cacheL2.containsKey(key)) {
                return null;
            }
            Map map2 = this._cacheL1;
            synchronized (map2) {
                newMap = HashMapUtils.merge(this._cacheL1, this._cacheL2);
                retval = newMap.remove(key);
            }
            this._cacheL1 = newMap;
            this._cacheL2.clear();
            this._missCount = 0;
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Map map = this._cacheL2;
        synchronized (map) {
            this.mergeIfL2NotEmpty();
            return this._cacheL1.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection values() {
        Map map = this._cacheL2;
        synchronized (map) {
            this.mergeIfL2NotEmpty();
            return Collections.unmodifiableCollection(this._cacheL1.values());
        }
    }

    private void mergeIfL2NotEmpty() {
        if (!this._cacheL2.isEmpty()) {
            this.merge(this._cacheL2);
        }
    }

    private void mergeIfNeeded() {
        if (++this._missCount >= this._mergeThreshold) {
            this.merge(this._cacheL2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(Map map) {
        HashMap newMap;
        Map map2 = this._cacheL1;
        synchronized (map2) {
            newMap = HashMapUtils.merge(this._cacheL1, map);
        }
        this._cacheL1 = newMap;
        this._cacheL2.clear();
        this._missCount = 0;
    }

    protected abstract Object newInstance(Object var1);
}

