/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.application.jsp;

import java.io.IOException;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.render.ResponseStateManager;
import net.sourceforge.myfaces.application.MyfacesStateManager;
import net.sourceforge.myfaces.application.TreeStructureManager;
import net.sourceforge.myfaces.renderkit.MyfacesResponseStateManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JspStateManagerImpl
extends MyfacesStateManager {
    private static final Log log = LogFactory.getLog((Class)(class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl == null ? (class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("net.sourceforge.myfaces.application.jsp.JspStateManagerImpl")) : class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl));
    private static final String SERIALIZED_VIEW_SESSION_ATTR = (class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl == null ? (class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("net.sourceforge.myfaces.application.jsp.JspStateManagerImpl")) : class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl).getName() + ".SERIALIZED_VIEW";
    private static final String SERIALIZED_VIEW_REQUEST_ATTR = (class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl == null ? (class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl = JspStateManagerImpl.class$("net.sourceforge.myfaces.application.jsp.JspStateManagerImpl")) : class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl).getName() + ".SERIALIZED_VIEW";
    private RenderKitFactory _renderKitFactory = null;
    static /* synthetic */ Class class$net$sourceforge$myfaces$application$jsp$JspStateManagerImpl;

    public JspStateManagerImpl() {
        if (log.isTraceEnabled()) {
            log.trace((Object)"New JspStateManagerImpl instance created");
        }
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot = facesContext.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        TreeStructureManager tsm = new TreeStructureManager();
        return tsm.buildTreeStructureToSave(viewRoot);
    }

    protected void restoreComponentState(FacesContext facesContext, UIViewRoot uiViewRoot, String renderKitId) {
        Object serializedComponentStates;
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
            serializedComponentStates = responseStateManager.getComponentStateToRestore(facesContext);
            if (serializedComponentStates == null) {
                log.error((Object)"No serialized component state found in client request!");
                uiViewRoot.setViewId(null);
                return;
            }
        } else {
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext.getExternalContext(), uiViewRoot.getViewId());
            if (serializedView == null) {
                log.error((Object)"No serialized view found in server session!");
                uiViewRoot.setViewId(null);
                return;
            }
            serializedComponentStates = serializedView.getState();
            if (serializedComponentStates == null) {
                log.error((Object)"No serialized component state found in server session!");
                return;
            }
        }
        if (uiViewRoot.getRenderKitId() == null) {
            uiViewRoot.setRenderKitId(renderKitId);
        }
        uiViewRoot.processRestoreState(facesContext, serializedComponentStates);
    }

    protected UIViewRoot restoreTreeStructure(FacesContext facesContext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot = null;
        if (this.isSavingStateInClient(facesContext)) {
            RenderKit rk = this.getRenderKitFactory().getRenderKit(facesContext, renderKitId);
            ResponseStateManager responseStateManager = rk.getResponseStateManager();
            Object treeStructure = responseStateManager.getTreeStructureToRestore(facesContext, viewId);
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No tree structure state found in client request");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)treeStructure);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from client request");
            }
        } else {
            StateManager.SerializedView serializedView = this.getSerializedViewFromServletSession(facesContext.getExternalContext(), viewId);
            if (serializedView == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No serialized view found in server session!");
                }
                return null;
            }
            Object treeStructure = serializedView.getStructure();
            if (treeStructure == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No tree structure state found in server session, former UIViewRoot must have been transient");
                }
                return null;
            }
            TreeStructureManager tsm = new TreeStructureManager();
            uiViewRoot = tsm.restoreTreeStructure((TreeStructureManager.TreeStructComponent)serializedView.getStructure());
            if (log.isTraceEnabled()) {
                log.trace((Object)"Tree structure restored from server session");
            }
        }
        return uiViewRoot;
    }

    public UIViewRoot restoreView(FacesContext facescontext, String viewId, String renderKitId) {
        UIViewRoot uiViewRoot = this.restoreTreeStructure(facescontext, viewId, renderKitId);
        if (uiViewRoot != null) {
            uiViewRoot.setViewId(viewId);
            this.restoreComponentState(facescontext, uiViewRoot, renderKitId);
            String restoredViewId = uiViewRoot.getViewId();
            if (restoredViewId == null || !restoredViewId.equals(viewId)) {
                return null;
            }
            if (!this.isSavingStateInClient(facescontext)) {
                this.removeSerializedViewFromServletSession(facescontext.getExternalContext(), viewId);
            }
        }
        return uiViewRoot;
    }

    public StateManager.SerializedView saveSerializedView(FacesContext facesContext) throws IllegalStateException {
        ExternalContext externalContext = facesContext.getExternalContext();
        StateManager.SerializedView serializedView = (StateManager.SerializedView)externalContext.getRequestMap().get(SERIALIZED_VIEW_REQUEST_ATTR);
        if (serializedView == null) {
            Object treeStruct = this.getTreeStructureToSave(facesContext);
            Object compStates = this.getComponentStateToSave(facesContext);
            serializedView = new StateManager.SerializedView((StateManager)this, treeStruct, compStates);
            externalContext.getRequestMap().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
        }
        if (this.isSavingStateInClient(facesContext)) {
            return serializedView;
        }
        this.saveSerializedViewInServletSession(externalContext, facesContext.getViewRoot().getViewId(), serializedView);
        return null;
    }

    public void writeState(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (!this.isSavingStateInClient(facesContext)) {
            throw new IllegalStateException("Must not be called in server state saving mode");
        }
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
        renderKit.getResponseStateManager().writeState(facesContext, serializedView);
    }

    public void writeStateAsUrlParams(FacesContext facesContext, StateManager.SerializedView serializedView) throws IOException {
        if (!this.isSavingStateInClient(facesContext)) {
            throw new IllegalStateException("Must not be called in server state saving mode");
        }
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        RenderKit renderKit = this.getRenderKitFactory().getRenderKit(facesContext, uiViewRoot.getRenderKitId());
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        if (responseStateManager instanceof MyfacesResponseStateManager) {
            ((MyfacesResponseStateManager)responseStateManager).writeStateAsUrlParams(facesContext, serializedView);
        } else {
            log.error((Object)("ResponseStateManager of render kit " + uiViewRoot.getRenderKitId() + " is no MyfacesResponseStateManager and does not support saving state in url parameters."));
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this._renderKitFactory == null) {
            this._renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        }
        return this._renderKitFactory;
    }

    protected void saveSerializedViewInServletSession(ExternalContext externalContext, String viewId, StateManager.SerializedView serializedView) {
        externalContext.getSessionMap().put(SERIALIZED_VIEW_SESSION_ATTR + "-" + viewId, new Object[]{viewId, serializedView});
    }

    protected StateManager.SerializedView getSerializedViewFromServletSession(ExternalContext externalContext, String viewId) {
        Object[] ar = (Object[])externalContext.getSessionMap().get(SERIALIZED_VIEW_SESSION_ATTR + "-" + viewId);
        if (ar == null) {
            return null;
        }
        String savedViewId = (String)ar[0];
        if (viewId == null || viewId.equals(savedViewId)) {
            return (StateManager.SerializedView)ar[1];
        }
        return null;
    }

    protected void removeSerializedViewFromServletSession(ExternalContext externalContext, String viewId) {
        externalContext.getSessionMap().remove(SERIALIZED_VIEW_SESSION_ATTR + "-" + viewId);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

