package org.seasar.struts.processor;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.config.ForwardConfig;

/**
 * @author Satoshi Kimura
 */
public interface ExternalRequestProcessor {

    /**
     * @see org.apache.struts.action.RequestProcessor#process(HttpServletRequest, HttpServletResponse)
     */
    public void process(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processMultipart(HttpServletRequest)
     */
    public HttpServletRequest processMultipart(HttpServletRequest request);

    /**
     * @see org.apache.struts.action.RequestProcessor#processPath(HttpServletRequest, HttpServletResponse)
     */
    public String processPath(HttpServletRequest request, HttpServletResponse response) throws IOException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processLocale(HttpServletRequest, HttpServletResponse)
     */
    public void processLocale(HttpServletRequest request, HttpServletResponse response);

    /**
     * @see org.apache.struts.action.RequestProcessor#processContent(HttpServletRequest, HttpServletResponse)
     */
    public void processContent(HttpServletRequest request, HttpServletResponse response);

    /**
     * @see org.apache.struts.action.RequestProcessor#processNoCache(HttpServletRequest, HttpServletResponse)
     */
    public void processNoCache(HttpServletRequest request, HttpServletResponse response);

    /**
     * @see org.apache.struts.action.RequestProcessor#processPreprocess(HttpServletRequest, HttpServletResponse)
     */
    public boolean processPreprocess(HttpServletRequest request, HttpServletResponse response);

    /**
     * @see org.apache.struts.action.RequestProcessor#processCachedMessages(HttpServletRequest, HttpServletResponse)
     */
    public void processCachedMessages(HttpServletRequest request, HttpServletResponse response);

    /**
     * @see org.apache.struts.action.RequestProcessor#processMapping(HttpServletRequest, HttpServletResponse, String)
     */
    public ActionMapping processMapping(HttpServletRequest request, HttpServletResponse response, String path)
            throws IOException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processRoles(HttpServletRequest, HttpServletResponse,
     *      ActionMapping)
     */
    public boolean processRoles(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
            throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processActionForm(HttpServletRequest, HttpServletResponse,
     *      ActionMapping)
     */
    public ActionForm processActionForm(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping);

    /**
     * @see org.apache.struts.action.RequestProcessor#processValidate(HttpServletRequest, HttpServletResponse,
     *      ActionForm, ActionMapping)
     */
    public boolean processValidate(HttpServletRequest request, HttpServletResponse response, ActionForm form,
            ActionMapping mapping) throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processActionPerform(HttpServletRequest, HttpServletResponse,
     *      Action, ActionForm, ActionMapping)
     */
    public ActionForward processActionPerform(HttpServletRequest request, HttpServletResponse response, Action action,
            ActionForm form, ActionMapping mapping) throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processPopulate(HttpServletRequest, HttpServletResponse,
     *      ActionForm, ActionMapping)
     */
    public void processPopulate(HttpServletRequest request, HttpServletResponse response, ActionForm form,
            ActionMapping mapping) throws ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processForward(HttpServletRequest, HttpServletResponse,
     *      ActionMapping)
     */
    public boolean processForward(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
            throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processInclude(HttpServletRequest, HttpServletResponse,
     *      ActionMapping)
     */
    public boolean processInclude(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
            throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processForwardConfig(HttpServletRequest, HttpServletResponse,
     *      ForwardConfig)
     */
    public void processForwardConfig(HttpServletRequest request, HttpServletResponse response, ForwardConfig forward)
            throws IOException, ServletException;

    /**
     * @see org.apache.struts.action.RequestProcessor#processActionCreate(HttpServletRequest, HttpServletResponse,
     *      ActionMapping)
     */
    public Action processActionCreate(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
            throws IOException;

    public Object getActionInstance(HttpServletRequest request, HttpServletResponse response, ActionMapping mapping)
            throws IOException;

    public ActionForward processActionExecute(HttpServletRequest request, HttpServletResponse response, Object action,
            ActionForm form, ActionMapping mapping) throws IOException, ServletException;

    /**
     * @return Returns the executeProcessor.
     */
    public ActionExecuteProcessor getExecuteProcessor();

    /**
     * @param executeProcessor The executeProcessor to set.
     */
    public void setExecuteProcessor(ActionExecuteProcessor executeProcessor);

}
