package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.component.S2UISelectItems;
import org.seasar.jsf.exception.NoValueReferenceRuntimeException;
import org.seasar.jsf.util.BindingUtil;

public abstract class HtmlSelectMenuTagBase extends HtmlInputTagBase {
	
	private String border;
	
	private String datafld;

	private String dataformatas;
	
	private String datasrc;
	
	private String items;
	
	private String itemLabel;
	
	private String itemValue;
	
	private String nullLabel;

	public void setBorder(String border) {
		this.border = border;
	}
	
	public void setDatafld(String datafld) {
		this.datafld = datafld;
	}
	
	public void setDataformatas(String dataformatas) {
		this.dataformatas = dataformatas;
	}

	public void setDatasrc(String datasrc) {
		this.datasrc = datasrc;
	}
	
	public void setItems(String items) {
		this.items = items;
	}
	
	public void setItemLabel(String itemLabel) {
		this.itemLabel = itemLabel;
	}
	
	public void setItemValue(String itemValue) {
		this.itemValue = itemValue;
	}
	
	public void setNullLabel(String nullLabel) {
		this.nullLabel = nullLabel;
	}
	
	public void release() {
		super.release();
		border = null;
		datafld = null;
		dataformatas = null;
		datasrc = null;
		items = null;
		itemLabel = null;
		itemValue = null;
		nullLabel = null;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.BORDER_ATTR, border);
		setComponentProperty(component, JsfConstants.DATAFLD_ATTR, datafld);
		setComponentProperty(component, JsfConstants.DATAFORMATAS_ATTR, dataformatas);
		setComponentProperty(component, JsfConstants.DATASRC_ATTR, datasrc);
		if (items != null) {
			if (!isValueReference(items)) {
				throw new NoValueReferenceRuntimeException(items);
			}
			S2UISelectItems child = new S2UISelectItems();
			BindingUtil.setValueBinding(child, JsfConstants.VALUE_ATTR, items);
			if (itemValue != null) {
				child.setItemValue(itemValue);
			}
			if (itemLabel != null) {
				child.setItemLabel(itemLabel);
			}
			if (nullLabel != null) {
				child.setNullLabel(nullLabel);
			}
			component.getChildren().add(child);
		}
	}
}