package org.seasar.jsf.taglib.html;

import javax.faces.component.UIComponent;

import org.seasar.jsf.JsfConstants;

public abstract class HtmlInputTagBase extends HtmlComponentTagBase {

	private String disabled;
	
	private String name;
	
	private String readonly;
	
	private String required;
	
	private String tabindex;

	private String validator;
	
	private String onblur;

	private String onchange;

	private String onfocus;

	private String onselect;
	
	public void setDisabled(String disabled) {
		this.disabled = disabled;
	}
	
	public void setName(String name) {
		this.name = name;
	}

	public void setReadonly(String readonly) {
		this.readonly = readonly;
	}
	
	public void setRequired(String required) {
		this.required = required;
	}
	
	public void setTabindex(String tabindex) {
		this.tabindex = tabindex;
	}

	public void setValidator(String validator) {
		this.validator = validator;
	}
	
	public void setOnblur(String onblur) {
		this.onblur = onblur;
	}
	
	public void setOnchange(String onchange) {
		this.onchange = onchange;
	}

	public void setOnfocus(String onfocus) {
		this.onfocus = onfocus;
	}
	
	public void setOnselect(String onselect) {
		this.onselect = onselect;
	}
	
	public void release() {
		super.release();
		disabled = null;
		name = null;
		readonly = null;
		required = null;
		tabindex = null;
		validator = null;
		onblur = null;
		onchange = null;
		onfocus = null;
		onselect = null;
	}
	
	protected void setProperties(UIComponent component) {
		super.setProperties(component);
		setComponentProperty(component, JsfConstants.DISABLED_ATTR, disabled);
		setComponentProperty(component, JsfConstants.NAME_ATTR, name);
		setComponentProperty(component, JsfConstants.READONLY_ATTR, readonly);
		setComponentProperty(component, JsfConstants.REQUIRED_ATTR, required);
		setComponentProperty(component, JsfConstants.TABINDEX_ATTR, tabindex);
		setValidatorProperty(component, validator);
		setComponentProperty(component, JsfConstants.ONBLUR_ATTR, onblur);
		setComponentProperty(component, JsfConstants.ONCHANGE_ATTR, onchange);
		setComponentProperty(component, JsfConstants.ONFOCUS_ATTR, onfocus);
		setComponentProperty(component, JsfConstants.ONSELECT_ATTR, onselect);
	}
}