package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.SelectBooleanCheckboxProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class SelectBooleanCheckboxSelector implements TagSelector {

	public SelectBooleanCheckboxSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.CHECKBOX_VALUE.equalsIgnoreCase(attributes
				.getValue(JsfConstants.TYPE_ATTR));
	}

	public TagProcessor createProcessor() {
		return new SelectBooleanCheckboxProcessor();
	}
}