package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.OutputTextProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class OutputTextSelector implements TagSelector {

	public OutputTextSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SPAN_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return attributes.getValue(JsfConstants.MAYA_NSURI,
				JsfConstants.INJECT_ATTR) == null
				&& attributes.getValue(JsfConstants.MAYA_NSURI,
						JsfConstants.VALUE_ATTR) != null;
	}

	public TagProcessor createProcessor() {
		return new OutputTextProcessor();
	}
}