package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.MetaContentTypeProcessor;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class MetaContentTypeSelector implements TagSelector {

	public MetaContentTypeSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		return JsfConstants.META_ELEM.equalsIgnoreCase(qName)
				&& JsfConstants.CONTENT_TYPE.equalsIgnoreCase(attributes
						.getValue(JsfConstants.HTTP_EQUIV_ATTR));
	}

	public TagProcessor createProcessor() {
		return new MetaContentTypeProcessor();
	}

}