package org.seasar.jsf.selector;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.TagProcessor;
import org.seasar.jsf.TagSelector;
import org.seasar.jsf.processor.TagProcessorImpl;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class InputTextSelector implements TagSelector {

	private static final String INJECT = "h:inputText";
	
	public InputTextSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.INPUT_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.TEXT_VALUE.equalsIgnoreCase(attributes
				.getValue(JsfConstants.TYPE_ATTR));
	}

	public TagProcessor createProcessor() {
		return new TagProcessorImpl(INJECT);
	}
}