package org.seasar.jsf.processor;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.JsfConfig;

/**
 * @author higa
 *
 */
public class ViewProcessor extends TagProcessorImpl {
	
	private static final String INJECT = "f:view";
	
	private String contentType;

	private String encoding;
	
	public ViewProcessor() {
	}

	public ViewProcessor(JsfConfig jsfConfig) {
		setProperty(JsfConstants.INJECT_ATTR, INJECT);
		processInject(jsfConfig);
	}
	
	public String getContentType() {
		return contentType;
	}

	public void setContentType(String contentType) {
		this.contentType = contentType;
		int index = contentType.indexOf(JsfConstants.CHARSET);
		if (index < 0) {
			throw new IllegalArgumentException(JsfConstants.CHARSET
					+ " not found in " + contentType);
		}
		int index2 = contentType.indexOf(JsfConstants.EQUAL, index + 1);
		encoding = contentType.substring(index2 + 1);
		encoding = encoding.trim();
	}

	public String getEncoding() {
		return encoding;
	}
}
