package org.seasar.jsf;

import java.util.Iterator;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public interface TagProcessor {

	public void process(JsfContext pagesContext, Tag parentTag)
			throws JspException;

	public int getChildCount();

	public TagProcessor getChild(int index);

	public void addChild(TagProcessor processor);

	public TagProcessor getParent();

	public void setParent(TagProcessor parent);

	public String getProperty(String name);

	public void setProperty(String name, String value);
	
	public Iterator getPropertyKeys();

	public void setup(String namespaceURI, String localName,
			String qName, Attributes attributes, JsfConfig jsfConfig);
	
	public void setProperties(Tag tag, JsfContext jsfContext);

	public TagProcessor findAncestor(Class clazz);
}