/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.myfaces.custom.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import net.sourceforge.myfaces.custom.tree.MutableTreeNode;
import net.sourceforge.myfaces.custom.tree.TreeNode;

public class DefaultMutableTreeNode
implements MutableTreeNode {
    private ArrayList children = new ArrayList();
    private Object userObject;
    MutableTreeNode parent;
    private boolean allowsChildren = true;

    public DefaultMutableTreeNode(Object userObject) {
        this.userObject = userObject;
    }

    public DefaultMutableTreeNode(ArrayList children, boolean allowsChildren) {
        this.children = children;
        this.allowsChildren = allowsChildren;
    }

    public DefaultMutableTreeNode(Object userObject, MutableTreeNode parent, boolean allowsChildren) {
        this.userObject = userObject;
        this.parent = parent;
        this.allowsChildren = allowsChildren;
    }

    public void insert(MutableTreeNode child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void insert(MutableTreeNode child, int index) {
        this.children.add(index, child);
        child.setParent(this);
    }

    public void remove(int index) {
        MutableTreeNode child = (MutableTreeNode)this.children.remove(index);
        child.setParent(null);
    }

    public void remove(MutableTreeNode node) {
        if (this.children.remove(node)) {
            node.setParent(null);
        }
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void removeFromParent() {
        if (this.parent == null) {
            return;
        }
        this.parent.remove(this);
    }

    public void setParent(MutableTreeNode parent) {
        this.parent = parent;
    }

    public TreeNode getChildAt(int index) {
        return (TreeNode)this.children.get(index);
    }

    public int getChildCount() {
        return this.children.size();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public Iterator children() {
        return Collections.unmodifiableCollection(this.children).iterator();
    }

    public String toString() {
        if (this.userObject != null) {
            return this.userObject.toString();
        }
        return super.toString();
    }
}

