package examples.jsf.action.impl;

import examples.jsf.action.EmployeeSearchAction;
import examples.jsf.common.Constants;
import examples.jsf.dto.EmployeeSearchDto;
import examples.jsf.exception.BadCriteriaRuntimeException;
import examples.jsf.logic.EmployeeLogic;

public class EmployeeSearchActionImpl implements EmployeeSearchAction {

	private EmployeeLogic employeeLogic;
	
	private EmployeeSearchDto employeeSearchDto;
	
	private int processMode;

	public void setEmployeeSearchDto(EmployeeSearchDto employeeSearchDto) {
		this.employeeSearchDto = employeeSearchDto;
	}
	
	public void setEmployeeLogic(EmployeeLogic employeeLogic) {
		this.employeeLogic = employeeLogic;
	} 

	public String checkSearchCount() {
		if (employeeLogic.getSearchCount(employeeSearchDto) == 0) {
			throw new BadCriteriaRuntimeException();
		}
		return "employeeList";
	}
	
	public int getProcessMode() {
		return processMode;
	}
	
	public String goEditForCreate() {
		processMode = Constants.CREATE_MODE;
		return "employeeEdit";
	}
}