/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.processor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.IterationTag;
import javax.servlet.jsp.tagext.Tag;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.util.ClassUtil;
import org.seasar.framework.util.StringUtil;
import org.seasar.jsf.JsfConfig;
import org.seasar.jsf.JsfContext;
import org.seasar.jsf.TagConfig;
import org.seasar.jsf.TagProcessor;
import org.xml.sax.Attributes;

public class TagProcessorImpl
implements TagProcessor {
    private Map properties = new HashMap();
    private Class tagClass;
    private List children = new ArrayList();
    private TagProcessor parent;
    private Set customPropertyNames = new HashSet();

    public TagProcessorImpl() {
    }

    public TagProcessorImpl(String inject) {
        this.setProperty("inject", inject);
    }

    public void setProperties(Tag tag, JsfContext jsfContext) {
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(tag.getClass());
        Iterator i = this.getPropertyKeys();
        while (i.hasNext()) {
            String propertyName = (String)i.next();
            String value = this.getProperty(propertyName);
            String s = value;
            if (StringUtil.isEmpty((String)s) || this.isCustomProperty(propertyName) || !beanDesc.hasPropertyDesc(propertyName) || value == null) continue;
            PropertyDesc pd = beanDesc.getPropertyDesc(propertyName);
            pd.setValue((Object)tag, (Object)value);
        }
    }

    public String getProperty(String name) {
        return (String)this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    public Iterator getPropertyKeys() {
        return this.properties.keySet().iterator();
    }

    protected void addCustomPropertyName(String name) {
        this.customPropertyNames.add(name);
    }

    protected boolean isCustomProperty(String name) {
        return this.customPropertyNames.contains(name);
    }

    public void setup(String namespaceURI, String localName, String qName, Attributes attributes, JsfConfig jsfConfig) {
        this.setupProperties(attributes);
        this.renameProperties();
        this.processInject(jsfConfig);
    }

    protected void setupProperties(Attributes attributes) {
        if (attributes == null) {
            return;
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            if ("http://www.seasar.org/maya".equals(attributes.getURI(i))) {
                this.properties.put(attributes.getLocalName(i), attributes.getValue(i));
            } else if (this.properties.get(attributes.getQName(i)) == null) {
                this.properties.put(attributes.getQName(i), attributes.getValue(i));
            }
            ++i;
        }
    }

    protected void renameProperties() {
        this.renameProperty("class", "styleClass");
    }

    protected void renameProperty(String from, String to) {
        if (this.properties.containsKey(from)) {
            Object value = this.properties.remove(from);
            this.properties.put(to, value);
        }
    }

    protected void processInject(JsfConfig jsfConfig) {
        String inject = this.getProperty("inject");
        if (inject != null) {
            TagConfig tagConfig = jsfConfig.getTagConfig(inject);
            this.setTagClass(tagConfig.getTagClass());
        }
    }

    protected Class getTagClass() {
        return this.tagClass;
    }

    protected void setTagClass(Class tagClass) {
        this.tagClass = tagClass;
    }

    public int getChildCount() {
        return this.children.size();
    }

    public TagProcessor getChild(int index) {
        return (TagProcessor)this.children.get(index);
    }

    public void addChild(TagProcessor child) {
        this.children.add(child);
        child.setParent(this);
    }

    public TagProcessor getParent() {
        return this.parent;
    }

    public void setParent(TagProcessor parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(JsfContext pagesContext, Tag parentTag) throws JspException {
        if (this.tagClass == null) {
            return;
        }
        Tag tag = (Tag)ClassUtil.newInstance((Class)this.tagClass);
        try {
            this.process(pagesContext, tag, parentTag);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            tag.release();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        tag.release();
    }

    protected void process(JsfContext pagesContext, Tag tag, Tag parentTag) throws JspException {
        if (parentTag != null) {
            tag.setParent(parentTag);
        }
        tag.setPageContext(pagesContext.getPageContext());
        this.setProperties(tag, pagesContext);
        if (tag instanceof BodyTag) {
            this.processBodyTag(pagesContext, (BodyTag)tag);
        } else if (tag instanceof IterationTag) {
            this.processIterationTag(pagesContext, (IterationTag)tag);
        } else {
            this.processTag(pagesContext, tag);
        }
    }

    protected void processTag(JsfContext pagesContext, Tag tag) throws JspException {
        if (tag.doStartTag() != 0) {
            this.processChildren(pagesContext, tag);
            tag.doEndTag();
        }
    }

    protected void processBodyTag(JsfContext pagesContext, BodyTag tag) throws JspException {
        if (tag.doStartTag() != 0) {
            do {
                PageContext pageContext = pagesContext.getPageContext();
                BodyContent bodyContent = pageContext.pushBody();
                tag.setBodyContent(bodyContent);
                this.processChildren(pagesContext, (Tag)tag);
                pageContext.popBody();
            } while (tag.doAfterBody() != 0);
            tag.doEndTag();
        }
    }

    protected void processIterationTag(JsfContext pagesContext, IterationTag tag) throws JspException {
        if (tag.doStartTag() != 0) {
            do {
                this.processChildren(pagesContext, (Tag)tag);
            } while (tag.doAfterBody() != 0);
            tag.doEndTag();
        }
    }

    protected void processChildren(JsfContext pagesContext, Tag parentTag) throws JspException {
        int i = 0;
        while (i < this.getChildCount()) {
            TagProcessor child = this.getChild(i);
            child.process(pagesContext, parentTag);
            ++i;
        }
    }

    public TagProcessor findAncestor(Class clazz) {
        if (this.parent == null) {
            return null;
        }
        if (clazz.isInstance(this.parent)) {
            return this.parent;
        }
        return this.parent.findAncestor(clazz);
    }
}

