/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.httpunit.core;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.directory.DirContext;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.loader.WebappLoader;
import org.apache.catalina.startup.ClassLoaderFactory;
import org.apache.catalina.startup.ContextConfig;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.TooManyRegistrationRuntimeException;
import org.seasar.framework.container.impl.S2ContainerImpl;
import org.seasar.framework.exception.IORuntimeException;
import org.seasar.httpunit.exception.ServletRuntimeException;

public class StandardContext
extends org.apache.catalina.core.StandardContext {
    private static final String TMP_DIR = "java.io.tmpdir";
    private static final String DEFAULT_WEB_XML = "org/seasar/httpunit/core/web.xml";
    private static final String HOST_NAME = "localhsot";
    private static final String CONTEXT_NAME = "/S2Ayaya";
    private final File logFile = new File(this.getWorkDir(), "/S2Ayaya.log");
    static /* synthetic */ Class class$java$lang$System;
    static /* synthetic */ Class class$org$apache$catalina$loader$WebappClassLoader;

    public StandardContext() {
        String loggerName = "tomcat.localhsot./S2Ayaya";
        Category logger = Logger.getInstance((String)loggerName);
        logger.setLevel(Level.WARN);
        try {
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), this.logFile.getAbsolutePath()));
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public ObjectName getParentName() throws MalformedObjectNameException {
        ObjectName parentName = new ObjectName("localhsot:type=Host,host=localhsot");
        return parentName;
    }

    public String getWorkDir() {
        return System.getProperty(TMP_DIR);
    }

    public boolean getPrivileged() {
        return true;
    }

    public void init() throws Exception {
        this.initSystemProperty();
        this.setCatalinaHome();
        this.setClassLoader();
        this.setName();
        this.addLifecycleListener();
        this.controller = this.oname;
        super.init();
    }

    private void initSystemProperty() {
        StandardContext.setSystemProperty("catalina.useNaming", "true");
        this.setDocumentBuilderImpl();
    }

    private void setDocumentBuilderImpl() {
        StandardContext.setSystemProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setSystemProperty(String key, String value) {
        Class clazz = class$java$lang$System == null ? (class$java$lang$System = StandardContext.class$("java.lang.System")) : class$java$lang$System;
        synchronized (clazz) {
            if (null == System.getProperty(key)) {
                System.setProperty(key, value);
            }
        }
    }

    private void setClassLoader() throws Exception {
        ClassLoader classLoader = this.createClassLoader();
        this.setparentClassLoader();
        this.setLoader(classLoader);
    }

    private ClassLoader createClassLoader() throws Exception {
        String docBase = this.getDocBase();
        File webInf = new File(new File(docBase), "WEB-INF");
        File[] unpacked = new File[]{new File(webInf, "classes")};
        File[] packed = new File[]{new File(webInf, "lib")};
        ClassLoader parentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader classLoader = ClassLoaderFactory.createClassLoader((File[])unpacked, (File[])packed, (ClassLoader)parentClassLoader);
        return classLoader;
    }

    private void setLoader(ClassLoader classLoader) {
        WebappLoader webappLoader = new WebappLoader(classLoader);
        webappLoader.setLoaderClass((class$org$apache$catalina$loader$WebappClassLoader == null ? (class$org$apache$catalina$loader$WebappClassLoader = StandardContext.class$("org.apache.catalina.loader.WebappClassLoader")) : class$org$apache$catalina$loader$WebappClassLoader).getName());
        webappLoader.setContainer((Container)this);
        webappLoader.setDelegate(true);
        Object context = null;
        context = new File(this.getDocBase()).isFile() && this.getDocBase().endsWith(".war") ? new WARDirContext() : new FileDirContext();
        webappLoader.getContainer().setResources((DirContext)context);
        this.setLoader((Loader)webappLoader);
    }

    private void setparentClassLoader() {
        this.parentClassLoader = Thread.currentThread().getContextClassLoader();
        this.setParentClassLoader(this.parentClassLoader);
    }

    private void addLifecycleListener() {
        ContextConfig contextConfig = new ContextConfig();
        contextConfig.setDefaultWebXml(DEFAULT_WEB_XML);
        super.addLifecycleListener((LifecycleListener)contextConfig);
    }

    private void setCatalinaHome() {
        System.setProperty("catalina.home", "");
    }

    private void setName() {
        StandardEngine engine = new StandardEngine();
        engine.setName("S2StrutsUnitEngine");
        StandardHost host = new StandardHost();
        host.setName(HOST_NAME);
        host.setParent((Container)engine);
        this.setParent((Container)host);
        this.setName(CONTEXT_NAME);
    }

    public void loadOnStartup() throws ServletException, IOException {
        List list = this.getChildrenList();
        StandardWrapper[] children = list.toArray(new StandardWrapper[list.size()]);
        super.loadOnStartup((Container[])children);
    }

    public Map getHttpServlets() {
        List children = this.getChildrenList();
        HashMap<String, Servlet> servlets = new HashMap<String, Servlet>();
        for (int i = 0; i < children.size(); ++i) {
            try {
                StandardWrapper wrapper = (StandardWrapper)children.get(i);
                Servlet servlet = wrapper.allocate();
                servlets.put(wrapper.getName(), servlet);
                wrapper.deallocate(servlet);
                continue;
            }
            catch (ServletException e) {
                e.printStackTrace();
                throw new ServletRuntimeException(e);
            }
        }
        return servlets;
    }

    public HttpServlet getHttpServlet(String servletName) {
        return (HttpServlet)this.getHttpServlets().get(servletName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpServlet getHttpServlet(Class servletClass) {
        S2ContainerImpl container = new S2ContainerImpl();
        try {
            Collection servlets = this.getHttpServlets().values();
            Iterator iterator = servlets.iterator();
            while (iterator.hasNext()) {
                container.register(iterator.next());
            }
            HttpServlet httpServlet = (HttpServlet)container.getComponent((Object)servletClass);
            return httpServlet;
        }
        catch (TooManyRegistrationRuntimeException e) {
            throw new org.seasar.httpunit.exception.TooManyRegistrationRuntimeException(e);
        }
        catch (ComponentNotFoundRuntimeException e) {
            HttpServlet httpServlet = null;
            return httpServlet;
        }
        finally {
            container.destroy();
        }
    }

    private List getChildrenList() {
        ArrayList children = new ArrayList();
        children.addAll(this.children.values());
        return children;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

