/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.auth;

public class HttpAuthRealm {
    private String scheme = null;
    private String realm = null;
    private String host = null;
    private int port = -1;

    public HttpAuthRealm(String host, int port, String realm, String scheme) {
        this.host = host;
        this.port = port;
        this.realm = realm;
        this.scheme = scheme;
    }

    public HttpAuthRealm(String host, int port, String realm) {
        this(host, port, realm, null);
    }

    public HttpAuthRealm(String host, int port) {
        this(host, port, null, null);
    }

    public HttpAuthRealm(String host, String realm) {
        this(host, -1, realm, null);
    }

    public HttpAuthRealm() {
        this(null, -1, null, null);
    }

    public HttpAuthRealm(HttpAuthRealm token) {
        this(token.host, token.port, token.realm, token.scheme);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getScheme() {
        return this.scheme;
    }

    private static boolean paramsMatchIgnoreCase(String p1, String p2) {
        return p1 == null || p2 == null || p1.equalsIgnoreCase(p2);
    }

    private static boolean paramsMatch(String p1, String p2) {
        return p1 == null || p2 == null || p1.equals(p2);
    }

    private static boolean paramsMatch(int p1, int p2) {
        return p1 < 0 || p2 < 0 || p1 == p2;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpAuthRealm)) {
            return super.equals(o);
        }
        HttpAuthRealm that = (HttpAuthRealm)o;
        return HttpAuthRealm.paramsMatchIgnoreCase(this.host, that.host) && HttpAuthRealm.paramsMatch(this.port, that.port) && HttpAuthRealm.paramsMatch(this.realm, that.realm) && HttpAuthRealm.paramsMatchIgnoreCase(this.scheme, that.scheme);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.scheme != null) {
            buffer.append(this.scheme);
            buffer.append(' ');
        }
        if (this.realm != null) {
            buffer.append("authentication realm '");
            buffer.append(this.realm);
            buffer.append("'");
        } else {
            buffer.append("default authentication realm ");
        }
        if (this.host != null) {
            buffer.append('@');
            buffer.append(this.host);
            if (this.port >= 0) {
                buffer.append(':');
                buffer.append(this.port);
            }
        }
        return buffer.toString();
    }

    public int hashCode() {
        return (this.host != null ? this.host.toLowerCase().hashCode() : 0) + (this.port >= 0 ? this.port : -1) + (this.realm != null ? this.realm.hashCode() : 0) + (this.scheme != null ? this.scheme.toLowerCase().hashCode() : 0);
    }
}

