/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployer;

import java.util.ArrayList;
import java.util.List;

import org.seasar.extension.unit.S2TestCase;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;

/**
 * @author koichik
 */
public class DeployerTest extends S2TestCase {
    private S2Container container;
    private int containerCount;
    private int componentDefCount;
    private List serviceComponents = new ArrayList();
    private List handlerComponents = new ArrayList();
    private List wsddFileNames = new ArrayList();

    public DeployerTest(String name) {
        super(name);
    }

    public void setUp() {
        containerCount = 0;
        componentDefCount = 0;
        serviceComponents.clear();
        handlerComponents.clear();
        wsddFileNames.clear();
    }

    public void testForEach0() {
        Deployer deployer = new DeployCounter();
        deployer.forEach(container);
        assertEquals(1, containerCount);
        assertEquals(0, componentDefCount);
    }

    public void testForEach1() {
        include("DeployerTest.forEach1.dicon");
        Deployer deployer = new DeployCounter();
        deployer.forEach(container);
        assertEquals(2, containerCount);
        assertEquals(1, componentDefCount);
    }

    public void testForEach2() {
        include("DeployerTest.forEach1.dicon");
        include("DeployerTest.forEach2.dicon");
        Deployer deployer = new DeployCounter();
        deployer.forEach(container);
        assertEquals(4, containerCount);
        assertEquals(4, componentDefCount);
    }

    public void testProcessContainer0() {
        createTestDeployer().forEach(container);
        assertEquals(0, wsddFileNames.size());
    }

    public void testProcessContainer1() {
        include("DeployerTest.processContainer1.dicon");
        createTestDeployer().forEach(container);
        assertEquals(2, wsddFileNames.size());
        assertEquals("foo.wsdd", wsddFileNames.get(0));
        assertEquals("bar.wsdd", wsddFileNames.get(1));
    }

    public void testProcessComponent0() {
        createTestDeployer().forEach(container);
        assertEquals(0, serviceComponents.size());
        assertEquals(0, handlerComponents.size());
    }

    public void testProcessComponent1() {
        include("DeployerTest.processComponent1.dicon");
        createTestDeployer().forEach(container);
        assertEquals(2, serviceComponents.size());
        assertEquals(1, handlerComponents.size());
    }

    private class DeployCounter extends Deployer {
        public void process(S2Container container) {
            ++containerCount;
        }

        public void process(ComponentDef compoenentDef) {
            ++componentDefCount;
        }
    };

    private Deployer createTestDeployer() {
        Deployer deployer = new Deployer();
        deployer.serviceDeployer = new ItemDeployer() {
            public void deploy(ComponentDef componentDef, MetaDef metaDef) {
                serviceComponents.add(componentDef);
            }
        };
        deployer.handlerDeployer = new ItemDeployer() {
            public void deploy(ComponentDef componentDef, MetaDef metaDef) {
                handlerComponents.add(componentDef);
            }
        };
        deployer.wsddDeployer = new ItemDeployer() {
            public void deploy(ComponentDef componentDef, MetaDef metaDef) {
                wsddFileNames.add(metaDef.getValue());
            }
        };
        return deployer;
    }
}