package org.seasar.remoting.axis.connector;

import java.lang.reflect.Method;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;

import org.apache.axis.encoding.TypeMappingRegistry;
import org.apache.axis.enum.Use;
import org.seasar.remoting.axis.S2AxisConstants;
import org.seasar.remoting.axis.encoding.AutoRegisterTypeMappingImpl;
import org.seasar.remoting.client.connector.impl.URLBasedConnector;

/**
 * @author koichik
 */
public class AxisConnector extends URLBasedConnector {
    protected Service service;

    /**
     * AxisT[rXݒ肵܂B
     * 
     * @param service AxisT[rX
     */
    public void setService(final Service service) {
        this.service = service;

        final TypeMappingRegistry tmr = (TypeMappingRegistry) service.getTypeMappingRegistry();
        if (!(tmr.getTypeMapping(Use.DEFAULT.getEncoding()) instanceof AutoRegisterTypeMappingImpl)) {
	        final AutoRegisterTypeMappingImpl autoTM = new AutoRegisterTypeMappingImpl(null);
	        tmr.register(Use.DEFAULT.getEncoding(), autoTM);
        }
    }

    /**
     * AxisT[rXgpă[g\bȟĂяosǍʂԂ܂B
     * 
     * @param targetURL
     *            [gIuWFNgURL
     * @param method
     *            Ăяo\bh
     * @param args
     *            [gIuWFNg̃\bhĂяoɓnli[IuWFNgz
     * @return [gIuWFNgɑ΂郁\bhĂяo̖߂l
     * @throws Throwable
     *             [gIuWFNgɑ΂郁\bhĂяoX[O
     */
    protected Object invoke(final URL targetURL, final Method method, final Object[] args) throws Throwable {
        final Call call = service.createCall();
        call.setTargetEndpointAddress(targetURL.toString());
        call.setOperationName(new QName(S2AxisConstants.OPERATION_NAMESPACE_URI, method.getName()));
        return call.invoke(args);
    }
}