/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.params.DefaultHttpParams;
import org.apache.commons.httpclient.util.DateParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DateParser {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$util$DateParser == null ? (class$org$apache$commons$httpclient$util$DateParser = DateParser.class$("org.apache.commons.httpclient.util.DateParser")) : class$org$apache$commons$httpclient$util$DateParser));
    public static final String KEY_DATE_PATTERNS = "http.dateParser.patterns";
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    static /* synthetic */ Class class$org$apache$commons$httpclient$util$DateParser;

    public static Date parseDate(String dateValue) throws DateParseException {
        List<String> patterns = (List<String>)DefaultHttpParams.getDefaultParams().getParameter(KEY_DATE_PATTERNS);
        if (patterns == null) {
            LOG.warn((Object)"DateParser patterns not included in the default params.");
            patterns = Arrays.asList(PATTERN_ASCTIME, PATTERN_RFC1036, PATTERN_RFC1123);
        }
        return DateParser.parseDate(dateValue, patterns);
    }

    private static Date parseDate(String dateValue, Collection dateFormats) throws DateParseException {
        if (dateValue == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (dateValue.length() > 1 && dateValue.startsWith("'") && dateValue.endsWith("'")) {
            dateValue = dateValue.substring(1, dateValue.length() - 1);
        }
        SimpleDateFormat dateParser = null;
        Iterator formatIter = dateFormats.iterator();
        while (formatIter.hasNext()) {
            String format = (String)formatIter.next();
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(format, Locale.US);
                dateParser.setTimeZone(TimeZone.getTimeZone("GMT"));
            } else {
                dateParser.applyPattern(format);
            }
            try {
                return dateParser.parse(dateValue);
            }
            catch (ParseException pe) {
            }
        }
        throw new DateParseException("Unable to parse the date " + dateValue);
    }

    private DateParser() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

