/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.axis.server.deployment;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.servlet.ServletContext;

import org.apache.axis.WSDDEngineConfiguration;
import org.apache.axis.deployment.wsdd.WSDDConstants;
import org.apache.axis.deployment.wsdd.WSDDDeployment;
import org.apache.axis.deployment.wsdd.WSDDDocument;
import org.apache.axis.deployment.wsdd.WSDDException;
import org.apache.axis.server.AxisServer;
import org.apache.axis.utils.XMLUtils;
import org.seasar.axis.S2AxisConstants;
import org.seasar.axis.server.DeployFailedException;
import org.seasar.axis.server.ServiceDef;
import org.seasar.framework.container.ComponentDef;
import org.seasar.framework.container.MetaDef;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.log.Logger;
import org.seasar.framework.message.MessageFormatter;
import org.seasar.framework.util.ResourceUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * dicont@CɋLqꂽR|[lgAxisɃfvC܂B
 * 
 * @author koichik
 */
public class Deployer {
    //class fields
    private final static Logger logger = Logger.getLogger(Deployer.class);

    //instance fields
    protected S2Container container;
    protected ServletContext servletContext;
    protected AxisServer axisEngine;
    protected WSDDEngineConfiguration configuration;
    protected WSDDDeployment deployment;

    /**
     * S2Reiݒ肵܂B
     * 
     * @param container
     *            S2Rei
     */
    public void setContainer(final S2Container container) {
        this.container = container;
    }

    /**
     * T[ubgReLXgݒ肵܂B
     * 
     * @param servletContext
     *            T[ubgReLXg
     */
    public void setServletContext(final ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    /**
     * AxisGW擾CReiɓo^ĂT[rXnhfvC܂B
     */
    public void deploy() {
        setupAxis();
        forEach(container.getRoot());
    }

    /**
     * AxisɃfvC邽߂̃ZbgAbvs܂B
     */
    protected void setupAxis() {
        axisEngine = (AxisServer) servletContext.getAttribute(S2AxisConstants.ATTR_AXIS_ENGINE);
        configuration = (WSDDEngineConfiguration) axisEngine.getConfig();
        deployment = configuration.getDeployment();
    }

    /**
     * Rei̊KwǂđSẴReiƃR|[lg`𑖍܂B <br>
     * 鏇͎̒ʂłB
     * <ol>
     * <li>Reig</li>
     * <li>q̃R|[lg`</li>
     * <li>q̃ReiċNI</li>
     * </ol>
     * 
     * @param container
     *            N_ƂȂRei
     */
    protected void forEach(final S2Container container) {
        process(container);

        final int componentDefSize = container.getComponentDefSize();
        for (int i = 0; i < componentDefSize; ++i) {
            process(container.getComponentDef(i));
        }

        final int childContainerSize = container.getChildSize();
        for (int i = 0; i < childContainerSize; ++i) {
            forEach(container.getChild(i));
        }
    }

    /**
     * S2ReiS2Axis̃^f[^ <code>&lt;meta name="s2axis:deploy"&gt;</code>
     * w肳Ă΁AWSDDAxisɃfvC܂B
     * 
     * @param container
     *            S2Rei
     */
    protected void process(final S2Container container) {
        final MetaDef[] metadataArray = container.getMetaDefs(S2AxisConstants.META_S2AXIS_DEPLOY);
        if (metadataArray != null) {
            for (int i = 0; i < metadataArray.length; ++i) {
                final Object value = metadataArray[i].getValue();
                if (value instanceof String) {
                    final String wsddFileName = (String) value;
                    deployWSDD(wsddFileName);
                    if (logger.isDebugEnabled()) {
                        logger.log("DAXS0001", new Object[] { wsddFileName });
                    }
                }
                else {
                    throw new DeployFailedException(MessageFormatter.getSimpleMessage("EAXS0002",
                            new Object[] { value }));
                }
            }
        }
    }

    /**
     * R|[lg`S2Axis̃^f[^ <code>&lt;meta name="s2axis:service"&gt;</code>
     * ܂ <code>&lt;meta name="s2axis:handler"&gt;</code>
     * w肳Ă΁ÃR|[lgT[rX܂̓nhƂAxisɃfvC܂B
     * 
     * @param componentDef
     *            R|[lg`
     */
    protected void process(final ComponentDef componentDef) {
        final MetaDef serviceMetaDef = componentDef.getMetaDef(S2AxisConstants.META_S2AXIS_SERVICE);
        if (serviceMetaDef != null) {
            final WSDDS2Service service = createWSDDS2Service(componentDef, serviceMetaDef);
            deployment.deployService(service);
            if (logger.isDebugEnabled()) {
                logger.log("DAXS0003", new Object[] { service.getQName() });
            }
        }

        final MetaDef handlerMetaDef = componentDef.getMetaDef(S2AxisConstants.META_S2AXIS_HANDLER);
        if (handlerMetaDef != null) {
            final WSDDS2Handler handler = new WSDDS2Handler(componentDef);
            deployment.deployHandler(handler);
            if (logger.isDebugEnabled()) {
                logger.log("DAXS0004", new Object[] { handler.getQName() });
            }
        }
    }

    /**
     * WSDDt@Ct@CVXe܂̓NXpXǂݍ݁AAxisɃfvC܂B
     * 
     * @param wsddFileName
     *            WSDDt@C̃pX
     */
    protected void deployWSDD(final String wsddFileName) {
        try {
            final InputStream is = ResourceUtil.getResourceAsStream(wsddFileName);
            final WSDDDocument wsddDocument = new WSDDDocument(XMLUtils.newDocument(is));
            wsddDocument.deploy(deployment);
        }
        catch (final Exception e) {
            throw new DeployFailedException(e);
        }
    }

    /**
     * <code>WSDDS2Service</code> CX^XĕԂ܂B <br>
     * ^f[^̎wɏ]A <code>ServiceDef</code> ܂WSDDt@C
     * <code>WSDDS2Service</code> CX^X܂B
     * 
     * @param componentDef
     *            R|[lg`
     * @param metaDef
     *            ^f[^`
     * @return <code>WSDDS2Service</code>
     */
    public WSDDS2Service createWSDDS2Service(final ComponentDef componentDef, final MetaDef metaDef) {
        try {
            Object metadata = metaDef.getValue();
            if (metadata == null) {
                return new WSDDS2Service(componentDef);
            }
            else if (metadata instanceof ServiceDef) {
                return new WSDDS2Service(componentDef, (ServiceDef) metadata);
            }
            else if (metadata instanceof String) {
                return new WSDDS2Service(componentDef, getServiceElement((String) metadata));
            }
            throw new DeployFailedException();
        }
        catch (final WSDDException e) {
            throw new DeployFailedException(e);
        }
    }

    /**
     * WSDDt@Ct@CVXe܂̓NXpXǂݍ݁A <code>&lt;service&gt;</code> vfԂ܂B
     * 
     * @param wsddFileName
     *            WSDDt@C̃pX
     * @return <code>&lt;service&gt;</code> vf
     */
    protected Element getServiceElement(final String wsddFileName) {
        try {
            final InputStream is = ResourceUtil.getResourceAsStream(wsddFileName);
            final Element documentElement = XMLUtils.newDocument(is).getDocumentElement();
            final Element[] serviceElements = getChildElements(documentElement,
                    WSDDConstants.ELEM_WSDD_SERVICE);
            if (serviceElements.length != 1) {
                throw new DeployFailedException(MessageFormatter.getSimpleMessage("EAXS0005",
                        new Object[] { wsddFileName }));
            }
            return serviceElements[0];
        }
        catch (final DeployFailedException e) {
            throw e;
        }
        catch (final Exception e) {
            throw new DeployFailedException(e);
        }
    }

    /**
     * w肳ꂽ[Jqvf̔zԂ܂B
     * 
     * @param parent
     *            evf
     * @param name
     *            qvf̃[J
     * @return w肳ꂽ[Jqvf̔zBYqvf݂Ȃꍇ͋̔zB
     */
    protected Element[] getChildElements(final Element parent, final String name) {
        final List result = new ArrayList();
        final NodeList children = parent.getChildNodes();
        for (int i = 0; i < children.getLength(); i++) {
            final Node thisNode = children.item(i);
            if (thisNode instanceof Element) {
                final Element element = (Element) thisNode;
                if (element.getLocalName().equals(name)) {
                    result.add(element);
                }
            }
        }
        return (Element[]) result.toArray(new Element[result.size()]);
    }
}