/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.httpclient.ConnectMethod;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.DefaultMethodRetryHandler;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpRecoverableException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.RedirectException;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthChallengeParser;
import org.apache.commons.httpclient.auth.AuthChallengeProcessor;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthState;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.CredentialsProvider;
import org.apache.commons.httpclient.auth.HttpAuthRealm;
import org.apache.commons.httpclient.auth.MalformedChallengeException;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpParams;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class HttpMethodDirector {
    public static final String WWW_AUTH_CHALLENGE = "WWW-Authenticate";
    public static final String WWW_AUTH_RESP = "Authorization";
    public static final String PROXY_AUTH_CHALLENGE = "Proxy-Authenticate";
    public static final String PROXY_AUTH_RESP = "Proxy-Authorization";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$HttpMethodDirector == null ? (class$org$apache$commons$httpclient$HttpMethodDirector = HttpMethodDirector.class$("org.apache.commons.httpclient.HttpMethodDirector")) : class$org$apache$commons$httpclient$HttpMethodDirector));
    private ConnectMethod connectMethod;
    private HttpState state;
    private HostConfiguration hostConfiguration;
    private HttpConnectionManager connectionManager;
    private HttpClientParams params;
    private HttpConnection conn;
    private boolean releaseConnection = false;
    private static final int AUTH_UNINITIATED = 0;
    private static final int AUTH_PREEMPTIVE = 1;
    private static final int AUTH_WWW_REQUIRED = 2;
    private static final int AUTH_PROXY_REQUIRED = 3;
    private static final int AUTH_NOT_REQUIRED = Integer.MAX_VALUE;
    private int authProcess = 0;
    private AuthChallengeProcessor authProcessor = null;
    private Set redirectLocations = null;
    static /* synthetic */ Class class$org$apache$commons$httpclient$HttpMethodDirector;

    public HttpMethodDirector(HttpConnectionManager connectionManager, HostConfiguration hostConfiguration, HttpClientParams params, HttpState state) {
        this.connectionManager = connectionManager;
        this.hostConfiguration = hostConfiguration;
        this.params = params;
        this.state = state;
        this.authProcessor = new AuthChallengeProcessor(this.params);
    }

    public void executeMethod(HttpMethod method) throws IOException, HttpException {
        block18: {
            if (method == null) {
                throw new IllegalArgumentException("Method may not be null");
            }
            this.hostConfiguration.getParams().setDefaults(this.params);
            method.getParams().setDefaults(this.hostConfiguration.getParams());
            try {
                int maxRedirects = this.params.getIntParameter("http.protocol.max-redirects", 100);
                int redirectCount = 0;
                while (true) {
                    if (this.conn != null && !this.hostConfiguration.hostEquals(this.conn)) {
                        this.conn.setLocked(false);
                        this.conn.releaseConnection();
                        this.conn = null;
                    }
                    if (this.conn == null) {
                        this.conn = this.connectionManager.getConnectionWithTimeout(this.hostConfiguration, this.params.getConnectionManagerTimeout());
                        this.conn.setLocked(true);
                        if (this.params.isAuthenticationPreemptive() || this.state.isAuthenticationPreemptive()) {
                            LOG.debug((Object)"Preemptively sending default basic credentials");
                            this.authProcess = 1;
                            method.getHostAuthState().setPreemptive();
                            if (this.conn.isProxied()) {
                                method.getProxyAuthState().setPreemptive();
                            }
                        }
                    }
                    this.authenticate(method);
                    this.executeWithRetry(method);
                    if (this.connectMethod != null) {
                        this.fakeResponse(method);
                        break;
                    }
                    boolean retry = false;
                    if (this.isRedirectNeeded(method) && this.processRedirectResponse(method)) {
                        retry = true;
                        if (++redirectCount >= maxRedirects) {
                            LOG.error((Object)"Narrowly avoided an infinite loop in execute");
                            throw new RedirectException("Maximum redirects (" + maxRedirects + ") exceeded");
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Execute redirect " + redirectCount + " of " + maxRedirects));
                        }
                    }
                    if (this.isAuthenticationNeeded(method)) {
                        if (this.processAuthenticationResponse(method)) {
                            retry = true;
                        }
                    } else {
                        this.authProcess = Integer.MAX_VALUE;
                    }
                    if (!retry) break;
                    if (method.getResponseBodyAsStream() == null) continue;
                    method.getResponseBodyAsStream().close();
                }
                Object var6_5 = null;
                if (this.conn == null) break block18;
                this.conn.setLocked(false);
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (this.conn != null) {
                    this.conn.setLocked(false);
                }
                if ((this.releaseConnection || method.getResponseBodyAsStream() == null) && this.conn != null) {
                    this.conn.releaseConnection();
                }
                throw throwable;
            }
        }
        if ((this.releaseConnection || method.getResponseBodyAsStream() == null) && this.conn != null) {
            this.conn.releaseConnection();
        }
    }

    private void authenticate(HttpMethod method) {
        try {
            this.authenticateProxy(method);
            this.authenticateHost(method);
        }
        catch (AuthenticationException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private boolean cleanAuthHeaders(HttpMethod method, String name) {
        Header[] authheaders = method.getRequestHeaders(name);
        boolean clean = true;
        int i = 0;
        while (i < authheaders.length) {
            Header authheader = authheaders[i];
            if (authheader.isAutogenerated()) {
                method.removeRequestHeader(authheader);
            } else {
                clean = false;
            }
            ++i;
        }
        return clean;
    }

    private void authenticateHost(HttpMethod method) throws AuthenticationException {
        if (!this.cleanAuthHeaders(method, WWW_AUTH_RESP)) {
            return;
        }
        AuthScheme authscheme = method.getHostAuthState().getAuthScheme();
        if (authscheme == null) {
            return;
        }
        if (this.authProcess == 2 || !authscheme.isConnectionBased()) {
            Credentials credentials;
            String host = this.conn.getVirtualHost();
            if (host == null) {
                host = this.conn.getHost();
            }
            int port = this.conn.getPort();
            HttpAuthRealm realm = new HttpAuthRealm(host, port, authscheme.getRealm(), authscheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + realm));
            }
            if ((credentials = this.state.getCredentials(realm)) != null) {
                String authstring = authscheme.authenticate(credentials, method);
                if (authstring != null) {
                    method.addRequestHeader(new Header(WWW_AUTH_RESP, authstring, true));
                }
            } else {
                LOG.warn((Object)"Required credentials not available");
            }
        }
    }

    private void authenticateProxy(HttpMethod method) throws AuthenticationException {
        if (!this.cleanAuthHeaders(method, PROXY_AUTH_RESP)) {
            return;
        }
        AuthScheme authscheme = method.getProxyAuthState().getAuthScheme();
        if (authscheme == null) {
            return;
        }
        if (this.authProcess == 3 || !authscheme.isConnectionBased()) {
            Credentials credentials;
            HttpAuthRealm realm = new HttpAuthRealm(this.conn.getProxyHost(), this.conn.getProxyPort(), authscheme.getRealm(), authscheme.getSchemeName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Authenticating with " + realm));
            }
            if ((credentials = this.state.getProxyCredentials(realm)) != null) {
                String authstring = authscheme.authenticate(credentials, method);
                if (authstring != null) {
                    method.addRequestHeader(new Header(PROXY_AUTH_RESP, authstring, true));
                }
            } else {
                LOG.warn((Object)"Required credentials not available");
            }
        }
    }

    private void executeWithRetry(HttpMethod method) throws IOException, HttpException {
        int recoverableExceptionCount = 0;
        int execCount = 0;
        boolean requestSent = false;
        try {
            while (true) {
                ++execCount;
                requestSent = false;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("Attempt number " + execCount + " to process request"));
                }
                if (!this.conn.isOpen()) {
                    this.conn.open();
                    if (this.conn.isProxied() && this.conn.isSecure() && !(method instanceof ConnectMethod) && !this.executeConnect()) {
                        return;
                    }
                }
                int timeout = 0;
                Object param = this.params.getParameter("http.socket.timeout");
                if (param == null) {
                    param = this.conn.getParams().getParameter("http.socket.timeout");
                }
                if (param != null) {
                    timeout = (Integer)param;
                }
                this.conn.setSocketTimeout(timeout);
                try {
                    method.execute(this.state, this.conn);
                }
                catch (HttpRecoverableException httpre) {
                    LOG.debug((Object)"Closing the connection.");
                    this.conn.close();
                    LOG.info((Object)"Recoverable exception caught when processing request");
                    ++recoverableExceptionCount;
                    MethodRetryHandler handler = method.getMethodRetryHandler();
                    if (handler != null) continue;
                    handler = new DefaultMethodRetryHandler();
                    if (handler.retryMethod(method, this.conn, httpre, execCount, requestSent)) continue;
                    LOG.warn((Object)"Recoverable exception caught but MethodRetryHandler.retryMethod() returned false, rethrowing exception");
                    throw httpre;
                }
                break;
            }
        }
        catch (IOException e) {
            if (this.conn.isOpen()) {
                LOG.debug((Object)"Closing the connection.");
                this.conn.close();
            }
            this.releaseConnection = true;
            throw e;
        }
        catch (RuntimeException e) {
            if (this.conn.isOpen()) {
                LOG.debug((Object)"Closing the connection.");
                this.conn.close();
            }
            this.releaseConnection = true;
            throw e;
        }
    }

    private boolean executeConnect() throws IOException, HttpException {
        int code;
        this.connectMethod = new ConnectMethod();
        this.connectMethod.getParams().setDefaults(this.params);
        while (true) {
            try {
                this.authenticateProxy(this.connectMethod);
            }
            catch (AuthenticationException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            this.executeWithRetry(this.connectMethod);
            code = this.connectMethod.getStatusCode();
            boolean retry = false;
            if (code == 407) {
                if (this.processAuthenticationResponse(this.connectMethod)) {
                    retry = true;
                }
            } else {
                this.authProcess = Integer.MAX_VALUE;
            }
            if (!retry) break;
            if (this.connectMethod.getResponseBodyAsStream() == null) continue;
            this.connectMethod.getResponseBodyAsStream().close();
        }
        if (code >= 200 && code < 300) {
            this.conn.tunnelCreated();
            this.connectMethod = null;
            return true;
        }
        return false;
    }

    private void fakeResponse(HttpMethod method) throws IOException, HttpException {
        LOG.debug((Object)"CONNECT failed, fake the response for the original method");
        if (method instanceof HttpMethodBase) {
            ((HttpMethodBase)method).fakeResponse(this.connectMethod.getStatusLine(), this.connectMethod.getResponseHeaderGroup(), this.connectMethod.getResponseBodyAsStream());
            method.getProxyAuthState().setAuthScheme(this.connectMethod.getProxyAuthState().getAuthScheme());
            this.connectMethod = null;
        } else {
            this.releaseConnection = true;
            LOG.warn((Object)"Unable to fake response on method as it is not derived from HttpMethodBase.");
        }
    }

    private boolean processRedirectResponse(HttpMethod method) throws RedirectException {
        Header locationHeader = method.getResponseHeader("location");
        if (locationHeader == null) {
            LOG.error((Object)("Received redirect response " + method.getStatusCode() + " but no location header"));
            return false;
        }
        String location = locationHeader.getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        URI redirectUri = null;
        URI currentUri = null;
        try {
            currentUri = new URI(this.conn.getProtocol().getScheme(), null, this.conn.getHost(), this.conn.getPort(), method.getPath());
            redirectUri = new URI(location, true);
            if (redirectUri.isRelativeURI()) {
                if (this.params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                    LOG.warn((Object)("Relative redirect location '" + location + "' not allowed"));
                    return false;
                }
                LOG.debug((Object)"Redirect URI is not absolute - parsing as relative");
                redirectUri = new URI(currentUri, redirectUri);
            }
            method.setURI(redirectUri);
            this.hostConfiguration.setHost(redirectUri);
        }
        catch (URIException e) {
            LOG.warn((Object)("Redirected location '" + location + "' is malformed"));
            return false;
        }
        if (this.params.isParameterFalse("http.protocol.allow-circular-redirects")) {
            if (this.redirectLocations == null) {
                this.redirectLocations = new HashSet();
            }
            this.redirectLocations.add(currentUri);
            if (this.redirectLocations.contains(redirectUri)) {
                throw new RedirectException("Circular redirect to '" + redirectUri + "'");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Redirecting from '" + currentUri.getEscapedURI() + "' to '" + redirectUri.getEscapedURI()));
        }
        method.getHostAuthState().invalidate();
        return true;
    }

    private boolean processAuthenticationResponse(HttpMethod method) {
        LOG.trace((Object)"enter HttpMethodBase.processAuthenticationResponse(HttpState, HttpConnection)");
        try {
            switch (method.getStatusCode()) {
                case 401: {
                    return this.processWWWAuthChallenge(method);
                }
                case 407: {
                    return this.processProxyAuthChallenge(method);
                }
            }
            return false;
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private boolean processWWWAuthChallenge(HttpMethod method) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authscheme;
        block12: {
            Map challenges;
            AuthState authstate = method.getHostAuthState();
            if (authstate.isPreemptive()) {
                authstate.invalidate();
            }
            if ((challenges = AuthChallengeParser.parseChallenges(method.getResponseHeaders(WWW_AUTH_CHALLENGE))).isEmpty()) {
                return false;
            }
            authscheme = null;
            try {
                authscheme = this.authProcessor.processChallenge(authstate, challenges);
            }
            catch (AuthChallengeException e) {
                if (!LOG.isWarnEnabled()) break block12;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (authscheme == null) {
            return false;
        }
        String host = this.conn.getVirtualHost();
        if (host == null) {
            host = this.conn.getHost();
        }
        int port = this.conn.getPort();
        HttpAuthRealm realm = new HttpAuthRealm(host, port, authscheme.getRealm(), authscheme.getSchemeName());
        if (this.authProcess == 2 && authscheme.isComplete()) {
            Credentials credentials = this.promptForCredentials(authscheme, method.getParams(), realm);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + realm));
                }
                return false;
            }
            return true;
        }
        this.authProcess = 2;
        Credentials credentials = this.state.getCredentials(realm);
        if (credentials == null) {
            credentials = this.promptForCredentials(authscheme, method.getParams(), realm);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No credentials available for the " + realm));
            }
            return false;
        }
        return true;
    }

    private boolean processProxyAuthChallenge(HttpMethod method) throws MalformedChallengeException, AuthenticationException {
        AuthScheme authscheme;
        block11: {
            Map proxyChallenges;
            AuthState authstate = method.getProxyAuthState();
            if (authstate.isPreemptive()) {
                authstate.invalidate();
            }
            if ((proxyChallenges = AuthChallengeParser.parseChallenges(method.getResponseHeaders(PROXY_AUTH_CHALLENGE))).isEmpty()) {
                return false;
            }
            authscheme = null;
            try {
                authscheme = this.authProcessor.processChallenge(authstate, proxyChallenges);
            }
            catch (AuthChallengeException e) {
                if (!LOG.isWarnEnabled()) break block11;
                LOG.warn((Object)e.getMessage());
            }
        }
        if (authscheme == null) {
            return false;
        }
        HttpAuthRealm realm = new HttpAuthRealm(this.conn.getProxyHost(), this.conn.getProxyPort(), authscheme.getRealm(), authscheme.getSchemeName());
        if (this.authProcess == 3 && authscheme.isComplete()) {
            Credentials credentials = this.promptForProxyCredentials(authscheme, method.getParams(), realm);
            if (credentials == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Failure authenticating with " + realm));
                }
                return false;
            }
            return true;
        }
        this.authProcess = 3;
        Credentials credentials = this.state.getProxyCredentials(realm);
        if (credentials == null) {
            credentials = this.promptForProxyCredentials(authscheme, method.getParams(), realm);
        }
        if (credentials == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No proxy credentials available for the " + realm));
            }
            return false;
        }
        return true;
    }

    private boolean isRedirectNeeded(HttpMethod method) {
        switch (method.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                LOG.debug((Object)"Redirect required");
                if (method.getFollowRedirects()) {
                    return true;
                }
                LOG.info((Object)"Redirect requested but followRedirects is disabled");
                return false;
            }
        }
        return false;
    }

    private boolean isAuthenticationNeeded(HttpMethod method) {
        switch (method.getStatusCode()) {
            case 401: 
            case 407: {
                LOG.debug((Object)"Authorization required");
                if (method.getDoAuthentication()) {
                    return true;
                }
                LOG.info((Object)"Authentication requested but doAuthentication is disabled");
                return false;
            }
        }
        return false;
    }

    private Credentials promptForCredentials(AuthScheme authScheme, HttpParams params, HttpAuthRealm realm) {
        Credentials creds = null;
        CredentialsProvider credProvider = (CredentialsProvider)params.getParameter("http.authentication.credential-provider");
        if (credProvider != null) {
            try {
                creds = credProvider.getCredentials(authScheme, realm.getHost(), realm.getPort(), false);
            }
            catch (CredentialsNotAvailableException e) {
                LOG.warn((Object)e.getMessage());
            }
            if (creds != null) {
                this.state.setCredentials(realm, creds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("New credentials for " + realm));
                }
            }
        }
        return creds;
    }

    private Credentials promptForProxyCredentials(AuthScheme authScheme, HttpParams params, HttpAuthRealm realm) {
        Credentials creds = null;
        CredentialsProvider credProvider = (CredentialsProvider)params.getParameter("http.authentication.credential-provider");
        if (credProvider != null) {
            try {
                creds = credProvider.getCredentials(authScheme, realm.getHost(), realm.getPort(), true);
            }
            catch (CredentialsNotAvailableException e) {
                LOG.warn((Object)e.getMessage());
            }
            if (creds != null) {
                this.state.setProxyCredentials(realm, creds);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("New proxy credentials for " + realm));
                }
            }
        }
        return creds;
    }

    public HostConfiguration getHostConfiguration() {
        return this.hostConfiguration;
    }

    public HttpState getState() {
        return this.state;
    }

    public HttpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public HttpParams getParams() {
        return this.params;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

