package org.seasar.struts;

import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.logging.Log;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.util.MessageResources;
import org.seasar.framework.container.ComponentNotFoundRuntimeException;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.ClassUtil;

/**
 * S2ƘAActioñCX^X𐶐ׂ̃NXłB
 * 
 * @author higa
 * @author Satoshi Kimura
 */
public final class ActionUtil {

    private ActionUtil() {
    }

    /**
     * @deprecated use createActionFromClassName(String).This method will delete at Ver1.1.
     * @see #createActionWithClassName(String)
     */
    public static Action createAction(String className) {
        return createActionWithClassName(className);
    }
    /**
     * {@link #createActionWithClassName(String, ActionServlet) }Ɠ̃\bhłB <br>
     * Ⴂ́AActioñCX^XɁAActionServletZbgȂƂłB
     * 
     * @see #createActionWithClassName(String, ActionServlet)
     */
    public static Action createActionWithClassName(String className) {
        return createActionWithClassName(className, null);
    }
    /**
     * S2ReiActionNX̃CX^X擾܂B <br>
     * S2ReiɎ擾Ώۂ̃NXo^ĂȂꍇACX^X擾̑OɁA S2ReiActionNX̓o^s܂B
     * 
     * @param className 擾Ώۂ̃NX
     * @param servlet ActionɃZbgActionServletBnull̏ꍇ́Anull̓Zbg܂B
     * @return S2Rei擾ActionNX̃CX^X
     */
    public static Action createActionWithClassName(String className, ActionServlet servlet) {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        Class clazz = ClassUtil.forName(className);
        synchronized (container) {
            if (false == container.hasComponentDef(clazz)) {
                container.register(clazz);
            }
            Action action = (Action) container.getComponent(clazz);
            setServlet(action, servlet);
            return action;
        }
    }

    /**
     * {@link #createActionWithComponentName(String, ActionServlet) }Ɠ̃\bhłB <br>
     * Ⴂ́AActioñCX^XɁAActionServletZbgȂƂłB
     * 
     * @see #createActionWithComponentName(String, ActionServlet)
     */
    public static Action createActionWithComponentName(String componentName) throws ComponentNotFoundRuntimeException {
        return createActionWithComponentName(componentName, null);
    }
    /**
     * S2ReiActionNX̃CX^X擾܂B <br>
     * 
     * @param componentName 擾Ώۂ̃R|[lg
     * @param servlet ActionɃZbgActionServletBnull̏ꍇ́Anull̓Zbg܂B
     * @return S2Rei擾ActionNX̃CX^X
     * @throws ComponentNotFoundRuntimeException R|[lgȂꍇ
     */
    public static Action createActionWithComponentName(String componentName, ActionServlet servlet)
            throws ComponentNotFoundRuntimeException {
        S2Container container = SingletonS2ContainerFactory.getContainer();
        synchronized (container) {
            Action action = (Action) container.getComponent(componentName);
            setServlet(action, servlet);
            return action;
        }
    }

    /**
     * ActionMappingQƂāAR|[lgCX^X𐶐̂ANXCX^X𐶐̂𔻒fāA ActioñCX^X𐶐B
     * 
     * @param request ĂHTTPNGXg
     * @param response HTTPX|X
     * @param mapping ActioñCX^X𐶐邽߂Ɏgp
     * @param log O
     * @param internal bZ[W\[X
     * @param servlet ActionɊ֘AÂĂServlet̃CX^X
     * @return S2Rei擾ActionNX̃CX^X
     * @throws IOException CX^XɎsꍇɁAX|X𑀍쎞ɔO
     */
    public static Action processActionCreate(HttpServletRequest request, HttpServletResponse response,
            ActionMapping mapping, Log log, MessageResources internal, ActionServlet servlet) throws IOException {

        Action instance = null;
        try {
            if (isCreateActionWithComponentName(mapping)) {
                S2Container container = SingletonS2ContainerFactory.getContainer();
                synchronized (container) {
                    ComponentNameCreator componentNameCreator = (ComponentNameCreator) container
                            .getComponent(ComponentNameCreator.class);
                    String componentName = componentNameCreator.createComponentName(container, mapping);
                    instance = createActionWithComponentName(componentName, servlet);
                }
            } else {
                String className = mapping.getType();
                if (log.isDebugEnabled()) {
                    log.debug(" Looking for Action instance for class " + className);
                }
                instance = createActionWithClassName(className, servlet);
            }
        } catch (Exception e) {
            String internalMessage = internal.getMessage("actionCreate", mapping.getPath());

            log.error(internalMessage, e);

            response.sendError(HttpServletResponse.SC_INTERNAL_SERVER_ERROR, internalMessage);

            return null;
        }
        return instance;
    }

    private static void setServlet(Action action, ActionServlet servlet) {
        if (servlet != null) {
            action.setServlet(servlet);
        }
    }

    private static boolean isCreateActionWithComponentName(ActionMapping mapping) {
        String type = mapping.getType();
        String forward = mapping.getForward();
        String include = mapping.getInclude();
        if (type == null && forward == null && include == null) {
            return true;
        } else {
            return false;
        }
    }
}