package examples.aop.throwsinterceptor;

import org.aopalliance.intercept.MethodInvocation;
import org.seasar.framework.aop.interceptors.ThrowsInterceptor;
import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.factory.S2ContainerFactory;

public class RetryExceptionInterceptor extends ThrowsInterceptor {
	private static String PATH = "examples/aop/throwsinterceptor/Random.dicon";

	public void handleThrowable(Throwable t, MethodInvocation invocation)
			throws Throwable {
		S2Container container = S2ContainerFactory.create(PATH);
		RandomNumber randomNumber = (RandomNumber) container
				.getComponent(RandomNumber.class);
		randomNumber.calc(5);
	}
}