/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

public class DoubleIntTable {
    private int[][] data;
    private int count = 0;
    private int sortedColumn = -1;
    private int targetSearchColumn;
    private int targetSearchValue;

    public DoubleIntTable(int n) {
        this.data = new int[][]{new int[n], new int[n]};
    }

    public int size() {
        return this.count;
    }

    public int get(int n, int n2) {
        return this.data[n2][n];
    }

    public void putSingle(int n, int n2, int n3) {
        this.data[n2][n] = n3;
        if (n2 == this.sortedColumn) {
            this.sortedColumn = -1;
        }
    }

    public void putPair(int n, int n2, int n3) {
        this.data[0][n] = n2;
        this.data[1][n] = n3;
        this.sortedColumn = -1;
    }

    public void add(int n, int n2) {
        if (this.count == this.data[0].length) {
            int[][] nArrayArray = new int[][]{new int[this.data[0].length * 2], new int[this.data[0].length * 2]};
            System.arraycopy(this.data[0], 0, nArrayArray[0], 0, this.count);
            System.arraycopy(this.data[1], 0, nArrayArray[1], 0, this.count);
            this.data = nArrayArray;
        }
        this.data[0][this.count] = n;
        this.data[1][this.count] = n2;
        ++this.count;
        this.sortedColumn = -1;
    }

    public synchronized int find(int n, int n2) {
        this.targetSearchColumn = n;
        this.targetSearchValue = n2;
        if (this.sortedColumn != this.targetSearchColumn) {
            this.fastQuickSort();
            this.sortedColumn = this.targetSearchColumn;
        }
        return this.binarySearch();
    }

    private int binarySearch() {
        int n = 0;
        int n2 = this.size();
        int n3 = 0;
        while (n < n2) {
            n3 = (n + n2) / 2;
            if (this.greaterThan(n3)) {
                n2 = n3;
                continue;
            }
            if (this.lessThan(n3)) {
                n = n3 + 1;
                continue;
            }
            return n3;
        }
        return -1;
    }

    private void fastQuickSort() {
        this.quickSort(0, this.size() - 1);
        this.insertionSort(0, this.size() - 1);
    }

    private void quickSort(int n, int n2) {
        int n3 = 4;
        if (n2 - n > n3) {
            int n4 = (n2 + n) / 2;
            if (this.lessThan(n4, n)) {
                this.swap(n, n4);
            }
            if (this.lessThan(n2, n)) {
                this.swap(n, n2);
            }
            if (this.lessThan(n2, n4)) {
                this.swap(n4, n2);
            }
            int n5 = n2 - 1;
            this.swap(n4, n5);
            n4 = n;
            int n6 = n5;
            while (true) {
                if (this.lessThan(++n4, n6)) {
                    continue;
                }
                while (this.lessThan(n6, --n5)) {
                }
                if (n5 < n4) break;
                this.swap(n4, n5);
            }
            this.swap(n4, n2 - 1);
            this.quickSort(n, n5);
            this.quickSort(n4 + 1, n2);
        }
    }

    private void insertionSort(int n, int n2) {
        for (int i = n + 1; i <= n2; ++i) {
            int n3;
            for (n3 = i; n3 > n && this.lessThan(i, n3 - 1); --n3) {
            }
            if (i == n3) continue;
            int n4 = this.data[0][i];
            int n5 = this.data[1][i];
            this.moveRows(n3, n3 + 1, i - n3);
            this.putPair(n3, n4, n5);
        }
    }

    private boolean lessThan(int n, int n2) {
        return this.data[this.targetSearchColumn][n] < this.data[this.targetSearchColumn][n2];
    }

    private boolean lessThan(int n) {
        return this.targetSearchValue > this.data[this.targetSearchColumn][n];
    }

    private boolean greaterThan(int n) {
        return this.targetSearchValue < this.data[this.targetSearchColumn][n];
    }

    void swap(int n, int n2) {
        int n3 = this.data[0][n];
        int n4 = this.data[1][n];
        this.data[0][n] = this.data[0][n2];
        this.data[1][n] = this.data[1][n2];
        this.data[0][n2] = n3;
        this.data[1][n2] = n4;
    }

    void moveRows(int n, int n2, int n3) {
        System.arraycopy(this.data[0], n, this.data[0], n2, n3);
        System.arraycopy(this.data[1], n, this.data[1], n2, n3);
    }
}

