/*
 * Decompiled with CFR 0.152.
 */
package org.openamf;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.ResultSet;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openamf.AMFBody;
import org.openamf.AMFError;
import org.openamf.AMFMessage;
import org.openamf.RequestContext;
import org.openamf.ServiceRequest;
import org.openamf.config.ConfigDigester;
import org.openamf.config.OpenAMFConfig;
import org.openamf.config.ServiceInvokerConfig;
import org.openamf.invoker.ServiceInvocationException;
import org.openamf.invoker.ServiceInvoker;
import org.openamf.io.AMFDeserializer;
import org.openamf.io.AMFSerializer;
import org.openamf.recordset.ASRecordSet;

public class DefaultGateway
extends HttpServlet {
    protected static Log log = LogFactory.getLog((Class)(class$org$openamf$DefaultGateway == null ? (class$org$openamf$DefaultGateway = DefaultGateway.class$("org.openamf.DefaultGateway")) : class$org$openamf$DefaultGateway));
    protected static Log requestLog = LogFactory.getLog((String)"org.openamf.REQUEST");
    protected static Log responseLog = LogFactory.getLog((String)"org.openamf.RESPONSE");
    private static final String OPENAMF_CONFIG = "OPENAMF_CONFIG";
    static /* synthetic */ Class class$org$openamf$DefaultGateway;

    public void init() throws ServletException {
        this.reloadConfig();
    }

    protected void initializeRequestContext(HttpServletRequest req) {
        RequestContext.setHttpServletRequest(req);
    }

    protected void clearRequestContext() {
        RequestContext.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.initializeRequestContext(req);
        AMFMessage requestMessage = null;
        AMFMessage responseMessage = null;
        try {
            requestMessage = this.deserializeAMFMessage(req);
            RequestContext.setRequestMessage(requestMessage);
            if (requestLog.isDebugEnabled()) {
                requestLog.debug((Object)("REQUEST:\n" + requestMessage + "\n"));
            } else if (requestLog.isInfoEnabled()) {
                requestLog.info((Object)("REQUEST:\n" + requestMessage.getBodiesString() + "\n"));
            }
            responseMessage = this.processMessage(req, requestMessage);
            if (responseLog.isDebugEnabled()) {
                responseLog.debug((Object)("RESPONSE:\n" + responseMessage + "\n"));
            } else if (responseLog.isInfoEnabled()) {
                responseLog.info((Object)("RESPONSE:\n" + responseMessage.getBodiesString() + "\n"));
            }
            this.serializeAMFMessage(resp, responseMessage);
        }
        catch (Exception e) {
            this.logRequestException(e, requestMessage);
        }
        finally {
            this.clearRequestContext();
        }
    }

    protected void logRequestException(Exception e, AMFMessage requestMessage) {
        String msg = "Error in service";
        if (requestMessage != null) {
            msg = msg + ", requestMessage=";
            msg = msg + String.valueOf(requestMessage);
        }
        if (e instanceof ServiceInvocationException) {
            ServiceInvocationException sie = (ServiceInvocationException)((Object)e);
            AMFBody body = sie.getAMFBody();
            ServiceRequest req = sie.getServiceRequest();
            if (body != null) {
                msg = msg + ", AMFBody=";
                msg = msg + String.valueOf(body);
            }
            if (req != null) {
                msg = msg + ", ServiceRequest=";
                msg = msg + String.valueOf(req);
            }
        }
        log.error((Object)msg, (Throwable)e);
    }

    protected AMFMessage deserializeAMFMessage(HttpServletRequest req) throws IOException {
        DataInputStream inputStream = new DataInputStream((InputStream)req.getInputStream());
        AMFDeserializer deserializer = new AMFDeserializer(inputStream);
        AMFMessage message = deserializer.getAMFMessage();
        return message;
    }

    protected void serializeAMFMessage(HttpServletResponse resp, AMFMessage message) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        AMFSerializer serializer = new AMFSerializer(dos);
        serializer.serializeMessage(message);
        resp.setContentType("application/x-amf");
        resp.setContentLength(baos.size());
        ServletOutputStream sos = resp.getOutputStream();
        baos.writeTo((OutputStream)sos);
        sos.flush();
    }

    protected AMFMessage processMessage(HttpServletRequest req, AMFMessage message) {
        AMFMessage responseMessage = new AMFMessage();
        Iterator bodies = message.getBodies();
        while (bodies.hasNext()) {
            AMFBody requestBody = (AMFBody)bodies.next();
            Object serviceResult = this.invokeBody(req, requestBody);
            String target = this.getTarget(requestBody, serviceResult);
            AMFBody responseBody = new AMFBody(target, "null", serviceResult);
            responseMessage.addBody(responseBody);
        }
        return responseMessage;
    }

    protected Object invokeBody(HttpServletRequest req, AMFBody requestBody) {
        Object serviceResult = null;
        try {
            ServiceInvoker serviceInvoker = this.getServiceInvoker(requestBody, req);
            if (serviceInvoker == null) {
                throw new ServiceInvocationException(requestBody, (Throwable)new Exception("No service for '" + requestBody.getServiceName() + "'"));
            }
            this.preInvokeService(req, serviceInvoker);
            serviceResult = serviceInvoker.invokeService();
            serviceResult = this.postInvokeService(req, serviceInvoker, serviceResult);
        }
        catch (ServiceInvocationException e) {
            serviceResult = e.getAMFError();
            this.logRequestException((Exception)((Object)e), null);
        }
        return serviceResult;
    }

    private String getTarget(AMFBody requestBody, Object serviceResult) {
        String target = "/onResult";
        if (serviceResult instanceof AMFError) {
            target = "/onStatus";
        }
        return requestBody.getResponse() + target;
    }

    protected void preInvokeService(HttpServletRequest httpServletRequest, ServiceInvoker serviceInvoker) throws ServiceInvocationException {
        if (serviceInvoker.getPersistService()) {
            Object persistentServiceObject = httpServletRequest.getSession().getAttribute(serviceInvoker.getPersistentServiceName());
            serviceInvoker.setPersistentServiceObject(persistentServiceObject);
        }
    }

    protected Object postInvokeService(HttpServletRequest httpServletRequest, ServiceInvoker serviceInvoker, Object serviceResult) throws ServiceInvocationException {
        if (serviceInvoker.getPersistService()) {
            httpServletRequest.getSession().setAttribute(serviceInvoker.getPersistentServiceName(), serviceInvoker.getPersistentServiceObject());
        }
        serviceResult = this.processRecordSet(httpServletRequest, serviceInvoker, serviceResult);
        return serviceResult;
    }

    private Object processRecordSet(HttpServletRequest httpServletRequest, ServiceInvoker serviceInvoker, Object serviceResult) throws ServiceInvocationException {
        ASRecordSet asRecordSet;
        if (serviceResult instanceof ResultSet) {
            asRecordSet = new ASRecordSet();
            try {
                asRecordSet.populate((ResultSet)serviceResult);
                serviceResult = asRecordSet;
            }
            catch (IOException e) {
                throw new ServiceInvocationException(serviceInvoker.getRequest(), (Throwable)e);
            }
        }
        if (serviceResult instanceof ASRecordSet && (asRecordSet = (ASRecordSet)serviceResult).getTotalCount() > asRecordSet.getInitialData().size()) {
            httpServletRequest.getSession().setAttribute(asRecordSet.getId(), (Object)asRecordSet);
        }
        return serviceResult;
    }

    protected ServiceInvoker getServiceInvoker(AMFBody requestBody, HttpServletRequest httpServletRequest) throws ServiceInvocationException {
        ServiceInvoker serviceInvoker = null;
        ServiceRequest request = new ServiceRequest(requestBody);
        try {
            Iterator i = OpenAMFConfig.getInstance().getServiceInvokerConfigs();
            while (i.hasNext()) {
                ServiceInvokerConfig invokerConfig = (ServiceInvokerConfig)i.next();
                log.debug((Object)("Checking if the " + invokerConfig.getName() + " Service Invoker can support the request"));
                ServiceInvoker tempInvoker = ServiceInvoker.load(invokerConfig.getClassName(), request, httpServletRequest, this.getServletContext());
                if (tempInvoker.supports(request)) {
                    serviceInvoker = tempInvoker;
                    serviceInvoker.prepare(request);
                    log.debug((Object)(invokerConfig.getName() + ": YES"));
                    break;
                }
                log.debug((Object)(invokerConfig.getName() + ": NO"));
            }
        }
        catch (Exception e) {
            throw new ServiceInvocationException(request, (Throwable)e);
        }
        return serviceInvoker;
    }

    protected OpenAMFConfig reloadConfig() {
        OpenAMFConfig config = OpenAMFConfig.getInstance();
        ConfigDigester configDigester = new ConfigDigester();
        configDigester.setUseContextClassLoader(true);
        String configParam = this.getServletConfig().getInitParameter(OPENAMF_CONFIG);
        String[] configLocations = StringUtils.split((String)configParam, (String)",");
        try {
            for (int i = 0; i < configLocations.length; ++i) {
                String configLocation = configLocations[i];
                InputStream inputStream = this.getServletContext().getResourceAsStream(configLocation);
                configDigester.clear();
                configDigester.push(config);
                configDigester.parse(inputStream);
            }
        }
        catch (Exception e) {
            log.error((Object)"Reload config error", (Throwable)e);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)config);
        }
        return config;
    }

    public String getServletInfo() {
        return "OpenAMF DefaultGateway servlet, http://www.openamf.org/";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

