package org.seasar.jsf.template.impl.html;

import org.seasar.jsf.JsfConstants;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.xml.sax.Attributes;

/**
 * @author higa
 *  
 */
public class HtmlMessageSelector implements TagSelector {

	public HtmlMessageSelector() {
	}

	public boolean isSelectable(String namespaceURI, String localName,
			String qName, Attributes attributes) {

		if (!JsfConstants.SPAN_ELEM.equalsIgnoreCase(qName)) {
			return false;
		}
		return JsfConstants.MESSAGE_VALUE.equalsIgnoreCase(attributes.getValue(
				JsfConstants.S2JSF_NSURI, JsfConstants.TYPE_ATTR));
	}

	public ComponentTreeBuilder createBuilder(String namespaceURI,
			String localName, String qName, Attributes attributes) {

		return new HtmlMessageBuilder(namespaceURI, localName, qName,
				attributes);
	}
}