package org.seasar.jsf.template.impl;

import java.io.File;

import javax.faces.component.UIViewRoot;

import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.ViewTemplate;

/**
 * @author higa
 *  
 */
public class ViewTemplateImpl implements ViewTemplate {

	private String viewId_;

	private ComponentTreeBuilder rootBuilder_;
	
	private File file_;
	
	private long lastModified_;

	public ViewTemplateImpl(String viewId, ComponentTreeBuilder rootBuilder, File file) {
		viewId_ = viewId;
		rootBuilder_ = rootBuilder;
		file_ = file;
		lastModified_ = file.lastModified();
	}

	public String getViewId() {
		return viewId_;
	}

	public ComponentTreeBuilder getRootBuilder() {
		return rootBuilder_;
	}

	public UIViewRoot createView() {
		UIViewRoot view = new UIViewRoot();
		view.setViewId(viewId_);
		rootBuilder_.buildTree(view);
		return view;
	}
	
	public boolean isModified() {
		return file_.lastModified() > lastModified_;
	}
}