package org.seasar.jsf.component.html;

import javax.faces.component.html.HtmlInputText;
import javax.faces.context.FacesContext;

/**
 * @author higa
 *
 */
public class HtmlInputTextX extends HtmlInputText {

	private boolean convertEmptyToNull_ = true;

	public boolean isConvertEmptyToNull() {
		return convertEmptyToNull_;
	}
	
	public void setConvertEmptyToNull(boolean convertEmptyToNull) {
		convertEmptyToNull_ = convertEmptyToNull;
	}
	
	public void setValue(Object value) {
		Object newValue = value;
		if (convertEmptyToNull_ && "".equals(value)) {
			newValue = null;
		}
		super.setValue(newValue);
	}
	
	public Object saveState(FacesContext context) {
		Object[] values = new Object[2];
		values[0] = super.saveState(context);
		values[1] = Boolean.valueOf(convertEmptyToNull_);
		return values;
	}

	public void restoreState(FacesContext context, Object state) {
		Object values[] = (Object[]) state;
		super.restoreState(context, values[0]);
		convertEmptyToNull_ = ((Boolean) values[1]).booleanValue();
	}
}
