/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.template.impl;

import java.util.Stack;
import org.seasar.jsf.template.ComponentTreeBuilder;
import org.seasar.jsf.template.TagSelector;
import org.seasar.jsf.template.impl.TagSelectors;
import org.seasar.jsf.template.impl.UITextBuilder;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class ViewTemplateHandler
extends DefaultHandler {
    private TagSelectors tagSelectors_;
    private Stack builderStack_ = new Stack();
    private ComponentTreeBuilder root_;

    public ViewTemplateHandler(TagSelectors tagSelectors) {
        this.tagSelectors_ = tagSelectors;
    }

    public ComponentTreeBuilder getRoot() {
        return this.root_;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) {
        ComponentTreeBuilder builder = this.createBuilder(namespaceURI, localName, qName, attributes);
        if (builder != null) {
            if (!this.builderStack_.isEmpty()) {
                ComponentTreeBuilder parent = (ComponentTreeBuilder)this.builderStack_.peek();
                parent.addChild(builder);
            } else {
                this.root_ = builder;
            }
            this.builderStack_.push(builder);
        }
    }

    protected ComponentTreeBuilder createBuilder(String namespaceURI, String localName, String qName, Attributes attributes) {
        TagSelector selector = this.tagSelectors_.getTagSelector(namespaceURI, localName, qName, attributes);
        if (selector != null) {
            return selector.createBuilder(namespaceURI, localName, qName, attributes);
        }
        return null;
    }

    public void characters(char[] buffer, int start, int length) {
        if (!this.builderStack_.isEmpty()) {
            ComponentTreeBuilder parent = (ComponentTreeBuilder)this.builderStack_.peek();
            parent.addChild(new UITextBuilder(new String(buffer, start, length)));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.builderStack_.pop();
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        System.err.println(e);
    }
}

