/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.jsf.render.html;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.Renderer;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.jsf.component.UIElement;
import org.seasar.jsf.util.BindingUtil;
import org.seasar.jsf.util.RenderUtil;

public class HtmlTagRenderer
extends Renderer {
    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!(component instanceof UIElement)) {
            throw new IllegalArgumentException("not UIElementNode");
        }
        String tagName = ((UIElement)component).getTagName();
        writer.startElement(tagName, component);
        this.renderPathThroughAttributes(writer, component);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement(((UIElement)component).getTagName());
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        RenderUtil.encodeChildren(context, component);
    }

    protected void renderPathThroughAttributes(ResponseWriter writer, UIComponent component) throws IOException {
        Map attrs = component.getAttributes();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String attrName = (String)i.next();
            if ("_BINDING_PROPERTY_NAMES_".equals(attrName)) continue;
            Object value = this.getValue(component, attrName);
            this.renderAttribute(writer, attrName, value, attrName);
        }
        BeanDesc beanDesc = BeanDescFactory.getBeanDesc(component.getClass());
        List bindingPropertyNames = (List)attrs.get("_BINDING_PROPERTY_NAMES_");
        int i2 = 0;
        while (i2 < bindingPropertyNames.size()) {
            String propertyName = (String)bindingPropertyNames.get(i2);
            if (!beanDesc.hasPropertyDesc(propertyName)) {
                Object value = BindingUtil.getBindingValue(component, propertyName);
                this.renderAttribute(writer, propertyName, value, propertyName);
            }
            ++i2;
        }
    }

    protected Object getValue(UIComponent component, String propertyName) {
        Object value = component.getAttributes().get(propertyName);
        if (value != null) {
            return value;
        }
        return BindingUtil.getBindingValue(component, propertyName);
    }

    protected void renderAttribute(ResponseWriter writer, String attributeName, Object value, String propertyName) throws IOException {
        if (value == null) {
            return;
        }
        writer.writeAttribute(this.changeAttributeName(attributeName), value, propertyName);
    }

    protected String changeAttributeName(String attributeName) {
        if ("styleClass".equalsIgnoreCase(attributeName)) {
            return "class";
        }
        return attributeName;
    }
}

